/*
 * Decompiled with CFR 0.152.
 */
package blbmod.init;

import blbmod.entity.BlueGalaxianEntity;
import blbmod.entity.BoomBossEntity;
import blbmod.entity.GreenGalaxianEntity;
import blbmod.entity.KyoumaEntity;
import blbmod.entity.RedGalaxianEntity;
import blbmod.entity.RocketLauncherEntity;
import blbmod.entity.SpecialBowEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlbModModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"blb_mod");
    public static final RegistryObject<EntityType<KyoumaEntity>> KYOUMA = BlbModModEntities.register("kyouma", EntityType.Builder.m_20704_(KyoumaEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(KyoumaEntity::new).m_20719_().m_20699_(0.6f, 1.6f));
    public static final RegistryObject<EntityType<RocketLauncherEntity>> ROCKET_LAUNCHER = BlbModModEntities.register("projectile_rocket_launcher", EntityType.Builder.m_20704_(RocketLauncherEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(RocketLauncherEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<BoomBossEntity>> BOOM_BOSS = BlbModModEntities.register("boom_boss", EntityType.Builder.m_20704_(BoomBossEntity::new, (MobCategory)MobCategory.UNDERGROUND_WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BoomBossEntity::new).m_20699_(0.6f, 2.55f));
    public static final RegistryObject<EntityType<BlueGalaxianEntity>> BLUE_GALAXIAN = BlbModModEntities.register("blue_galaxian", EntityType.Builder.m_20704_(BlueGalaxianEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BlueGalaxianEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<RedGalaxianEntity>> RED_GALAXIAN = BlbModModEntities.register("red_galaxian", EntityType.Builder.m_20704_(RedGalaxianEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).setCustomClientFactory(RedGalaxianEntity::new).m_20719_().m_20699_(0.6f, 2.0f));
    public static final RegistryObject<EntityType<GreenGalaxianEntity>> GREEN_GALAXIAN = BlbModModEntities.register("green_galaxian", EntityType.Builder.m_20704_(GreenGalaxianEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).setCustomClientFactory(GreenGalaxianEntity::new).m_20699_(0.6f, 2.0f));
    public static final RegistryObject<EntityType<SpecialBowEntity>> SPECIAL_BOW = BlbModModEntities.register("projectile_special_bow", EntityType.Builder.m_20704_(SpecialBowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(SpecialBowEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            KyoumaEntity.init();
            BoomBossEntity.init();
            BlueGalaxianEntity.init();
            RedGalaxianEntity.init();
            GreenGalaxianEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)KYOUMA.get(), KyoumaEntity.createAttributes().m_22265_());
        event.put((EntityType)BOOM_BOSS.get(), BoomBossEntity.createAttributes().m_22265_());
        event.put((EntityType)BLUE_GALAXIAN.get(), BlueGalaxianEntity.createAttributes().m_22265_());
        event.put((EntityType)RED_GALAXIAN.get(), RedGalaxianEntity.createAttributes().m_22265_());
        event.put((EntityType)GREEN_GALAXIAN.get(), GreenGalaxianEntity.createAttributes().m_22265_());
    }
}

