/*
 * Decompiled with CFR 0.152.
 */
package com.example.serverselector;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Serverselector
extends JavaPlugin
implements Listener {
    private Inventory gui;
    private Map<Integer, String> commandMap = new HashMap<Integer, String>();
    private String guiTitle;
    private int guiSize;
    private ItemStack selectorItem;
    private Set<Integer> usedSlots = new HashSet<Integer>();
    private boolean placeholderAPIEnabled = false;
    private BukkitRunnable updateTask;

    public void onEnable() {
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderAPIEnabled = true;
            this.getLogger().info("PlaceholderAPI found! Dynamic placeholders enabled.");
        } else {
            this.getLogger().info("PlaceholderAPI not found. Dynamic placeholders disabled.");
        }
        this.saveDefaultConfig();
        this.loadGUI();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("servergui").setExecutor((CommandExecutor)new ServerGUICommand());
        this.startUpdateTask();
        this.getLogger().info("ServerGUI has been enabled!");
    }

    public void onDisable() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.getLogger().info("ServerGUI has been disabled!");
    }

    private void startUpdateTask() {
        if (this.placeholderAPIEnabled && this.getConfig().getBoolean("auto-refresh.enabled", false)) {
            int interval = this.getConfig().getInt("auto-refresh.interval", 30) * 20;
            this.updateTask = new BukkitRunnable(){

                public void run() {
                    Serverselector.this.updateGUIItems();
                }
            };
            this.updateTask.runTaskTimer((Plugin)this, (long)interval, (long)interval);
            this.getLogger().info("Auto-refresh enabled with " + interval / 20 + " second interval");
        }
    }

    private void updateGUIItems() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection == null) {
            return;
        }
        for (String key : itemsSection.getKeys(false)) {
            ItemStack item;
            int slot;
            ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
            if (itemSection == null || !this.usedSlots.contains(slot = itemSection.getInt("slot", 0))) continue;
            String material = itemSection.getString("material", "STONE");
            String name = itemSection.getString("name", "Server");
            List lore = itemSection.getStringList("lore");
            try {
                item = new ItemStack(Material.valueOf((String)material.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                item = new ItemStack(Material.STONE);
            }
            ItemMeta meta = item.getItemMeta();
            String processedName = name;
            if (this.placeholderAPIEnabled) {
                processedName = PlaceholderAPI.setPlaceholders(null, (String)processedName);
            }
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)processedName));
            ArrayList<String> processedLore = new ArrayList<String>();
            Iterator iterator = lore.iterator();
            while (iterator.hasNext()) {
                String loreLine;
                String processedLine = loreLine = (String)iterator.next();
                if (this.placeholderAPIEnabled) {
                    processedLine = PlaceholderAPI.setPlaceholders(null, (String)processedLine);
                }
                processedLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)processedLine));
            }
            meta.setLore(processedLore);
            item.setItemMeta(meta);
            this.gui.setItem(slot, item);
        }
    }

    private void loadGUI() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        String rawTitle = config.getString("gui.title", "Server Selector");
        if (this.placeholderAPIEnabled) {
            rawTitle = PlaceholderAPI.setPlaceholders(null, (String)rawTitle);
        }
        this.guiTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)rawTitle);
        this.guiSize = config.getInt("gui.size", 27);
        this.gui = Bukkit.createInventory(null, (int)this.guiSize, (String)this.guiTitle);
        this.commandMap.clear();
        this.usedSlots.clear();
        this.loadSelectorItem();
        this.loadGUIItems();
        this.fillEmptySlots();
        this.startUpdateTask();
    }

    private void loadSelectorItem() {
        FileConfiguration config = this.getConfig();
        String selectorMaterial = config.getString("selector.material", "COMPASS");
        String selectorName = config.getString("selector.name", "&6Server Selector");
        List selectorLore = config.getStringList("selector.lore");
        if (this.placeholderAPIEnabled) {
            selectorName = PlaceholderAPI.setPlaceholders(null, (String)selectorName);
        }
        ArrayList<String> coloredLore = new ArrayList<String>();
        Iterator iterator = selectorLore.iterator();
        while (iterator.hasNext()) {
            String loreLine;
            String processedLine = loreLine = (String)iterator.next();
            if (this.placeholderAPIEnabled) {
                processedLine = PlaceholderAPI.setPlaceholders(null, (String)processedLine);
            }
            coloredLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)processedLine));
        }
        try {
            this.selectorItem = new ItemStack(Material.valueOf((String)selectorMaterial.toUpperCase()));
            ItemMeta selectorMeta = this.selectorItem.getItemMeta();
            selectorMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)selectorName));
            selectorMeta.setLore(coloredLore);
            this.selectorItem.setItemMeta(selectorMeta);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid material for selector item: " + selectorMaterial);
            this.selectorItem = new ItemStack(Material.COMPASS);
            ItemMeta fallbackMeta = this.selectorItem.getItemMeta();
            fallbackMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)selectorName));
            fallbackMeta.setLore(coloredLore);
            this.selectorItem.setItemMeta(fallbackMeta);
        }
    }

    private void loadGUIItems() {
        FileConfiguration config = this.getConfig();
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection == null) {
            return;
        }
        for (String key : itemsSection.getKeys(false)) {
            ItemStack item;
            ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
            if (itemSection == null) continue;
            int slot = itemSection.getInt("slot", 0);
            String material = itemSection.getString("material", "STONE");
            String name = itemSection.getString("name", "Server");
            List lore = itemSection.getStringList("lore");
            String command = itemSection.getString("command", "");
            try {
                item = new ItemStack(Material.valueOf((String)material.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid material for item " + key + ": " + material);
                item = new ItemStack(Material.STONE);
            }
            ItemMeta meta = item.getItemMeta();
            String processedName = name;
            if (this.placeholderAPIEnabled) {
                processedName = PlaceholderAPI.setPlaceholders(null, (String)processedName);
            }
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)processedName));
            ArrayList<String> coloredItemLore = new ArrayList<String>();
            Iterator iterator = lore.iterator();
            while (iterator.hasNext()) {
                String loreLine;
                String processedLine = loreLine = (String)iterator.next();
                if (this.placeholderAPIEnabled) {
                    processedLine = PlaceholderAPI.setPlaceholders(null, (String)processedLine);
                }
                coloredItemLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)processedLine));
            }
            meta.setLore(coloredItemLore);
            item.setItemMeta(meta);
            this.gui.setItem(slot, item);
            this.commandMap.put(slot, command);
            this.usedSlots.add(slot);
        }
    }

    private void fillEmptySlots() {
        ConfigurationSection decorationSection = this.getConfig().getConfigurationSection("decoration");
        boolean usePattern = false;
        ArrayList<String> pattern = new ArrayList();
        if (decorationSection != null && decorationSection.getBoolean("enabled", true)) {
            usePattern = decorationSection.getBoolean("use-pattern", false);
            pattern = decorationSection.getStringList("pattern");
        }
        if (usePattern && !pattern.isEmpty()) {
            ArrayList<ItemStack> decorationItems = new ArrayList<ItemStack>();
            ConfigurationSection patternItemsSection = decorationSection.getConfigurationSection("pattern-items");
            if (patternItemsSection != null) {
                for (String key : patternItemsSection.getKeys(false)) {
                    ItemStack item;
                    String material = patternItemsSection.getString(key + ".material", "GRAY_STAINED_GLASS_PANE");
                    String name = patternItemsSection.getString(key + ".name", " ");
                    try {
                        item = new ItemStack(Material.valueOf((String)material.toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        item = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                    }
                    ItemMeta meta = item.getItemMeta();
                    String processedName = name;
                    if (this.placeholderAPIEnabled) {
                        processedName = PlaceholderAPI.setPlaceholders(null, (String)processedName);
                    }
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)processedName));
                    item.setItemMeta(meta);
                    decorationItems.add(item);
                }
            }
            if (decorationItems.isEmpty()) {
                ItemStack defaultPane = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                ItemMeta meta = defaultPane.getItemMeta();
                meta.setDisplayName(" ");
                defaultPane.setItemMeta(meta);
                decorationItems.add(defaultPane);
            }
            int itemIndex = 0;
            for (int i = 0; i < this.guiSize; ++i) {
                if (this.usedSlots.contains(i)) continue;
                char patternChar = this.getPatternCharForSlot(i, pattern);
                if (patternChar != ' ') {
                    int itemId = patternChar - 49;
                    if (itemId >= 0 && itemId < decorationItems.size()) {
                        this.gui.setItem(i, (ItemStack)decorationItems.get(itemId));
                        continue;
                    }
                    this.gui.setItem(i, (ItemStack)decorationItems.get(itemIndex % decorationItems.size()));
                    ++itemIndex;
                    continue;
                }
                this.gui.setItem(i, null);
            }
        } else {
            Material[] glassPanes = new Material[]{Material.GRAY_STAINED_GLASS_PANE, Material.BLACK_STAINED_GLASS_PANE};
            boolean alternateColors = decorationSection != null && decorationSection.getBoolean("alternate-colors", true);
            for (int i = 0; i < this.guiSize; ++i) {
                ItemStack pane;
                if (this.usedSlots.contains(i)) continue;
                if (alternateColors) {
                    boolean isEdge = i < 9 || i >= this.guiSize - 9 || i % 9 == 0 || i % 9 == 8;
                    pane = new ItemStack(isEdge ? glassPanes[0] : glassPanes[1]);
                } else {
                    pane = new ItemStack(glassPanes[0]);
                }
                ItemMeta meta = pane.getItemMeta();
                meta.setDisplayName(" ");
                pane.setItemMeta(meta);
                this.gui.setItem(i, pane);
            }
        }
    }

    private char getPatternCharForSlot(int slot, List<String> pattern) {
        String rowPattern;
        int row = slot / 9;
        int col = slot % 9;
        if (row < pattern.size() && col < (rowPattern = pattern.get(row)).length()) {
            return rowPattern.charAt(col);
        }
        return ' ';
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore() || this.getConfig().getBoolean("give-on-every-join", false)) {
            ItemStack playerSelectorItem = this.updateItemWithPlayerPlaceholders(this.selectorItem.clone(), player);
            player.getInventory().setItem(this.getConfig().getInt("selector.slot", 0), playerSelectorItem);
        }
    }

    private ItemStack updateItemWithPlayerPlaceholders(ItemStack item, Player player) {
        if (!this.placeholderAPIEnabled || item == null || !item.hasItemMeta()) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            String newName = PlaceholderAPI.setPlaceholders((Player)player, (String)meta.getDisplayName());
            meta.setDisplayName(newName);
        }
        if (meta.hasLore()) {
            ArrayList<String> newLore = new ArrayList<String>();
            for (String loreLine : meta.getLore()) {
                newLore.add(PlaceholderAPI.setPlaceholders((Player)player, (String)loreLine));
            }
            meta.setLore(newLore);
        }
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals(this.guiTitle)) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            int slot = event.getSlot();
            if (this.commandMap.containsKey(slot)) {
                String command = this.commandMap.get(slot);
                player.closeInventory();
                this.executeCommand(player, command);
            }
        } else if (event.getCurrentItem() != null && event.getCurrentItem().hasItemMeta() && event.getCurrentItem().getItemMeta().hasDisplayName() && this.selectorItem != null && this.selectorItem.hasItemMeta() && event.getCurrentItem().getItemMeta().getDisplayName().equals(this.selectorItem.getItemMeta().getDisplayName()) && this.getConfig().getBoolean("lock-selector-item", true)) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            this.openGUIForPlayer(player);
        }
    }

    private void openGUIForPlayer(Player player) {
        if (this.placeholderAPIEnabled) {
            Inventory playerGUI = Bukkit.createInventory(null, (int)this.guiSize, (String)this.guiTitle);
            for (int i = 0; i < this.guiSize; ++i) {
                ItemStack item = this.gui.getItem(i);
                if (item == null) continue;
                ItemStack playerItem = this.updateItemWithPlayerPlaceholders(item.clone(), player);
                playerGUI.setItem(i, playerItem);
            }
            player.openInventory(playerGUI);
        } else {
            player.openInventory(this.gui);
        }
    }

    private void executeCommand(Player player, String command) {
        if (command == null || command.isEmpty()) {
            return;
        }
        String processedCommand = command;
        if (this.placeholderAPIEnabled) {
            processedCommand = PlaceholderAPI.setPlaceholders((Player)player, (String)processedCommand);
        }
        if (processedCommand.startsWith("console:")) {
            String consoleCommand = processedCommand.substring(8).trim();
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)consoleCommand.replace("%player%", player.getName()));
            return;
        }
        if (processedCommand.startsWith("server:")) {
            String serverName = processedCommand.substring(7).trim();
            try {
                this.connectToServer(player, serverName);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Connecting to " + serverName + "...");
            }
            catch (Exception e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to connect to " + serverName);
                this.getLogger().warning("Failed to connect player " + player.getName() + " to server " + serverName);
                e.printStackTrace();
            }
            return;
        }
        if (processedCommand.startsWith("message:")) {
            String message = processedCommand.substring(8).trim();
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            return;
        }
        if (!processedCommand.startsWith("none")) {
            player.performCommand(processedCommand.replace("%player%", player.getName()));
        }
    }

    private void connectToServer(Player player, String server) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("Connect");
            out.writeUTF(server);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendPluginMessage((Plugin)this, "BungeeCord", b.toByteArray());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && this.selectorItem != null && this.selectorItem.hasItemMeta() && item.getItemMeta().getDisplayName().equals(this.selectorItem.getItemMeta().getDisplayName())) {
            event.setCancelled(true);
            this.openGUIForPlayer(player);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getView().getTitle().equals(this.guiTitle)) {
            event.setCancelled(true);
        }
    }

    private class ServerGUICommand
    implements CommandExecutor {
        private ServerGUICommand() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("servergui.reload")) {
                    Serverselector.this.loadGUI();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "ServerGUI configuration reloaded!");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload the configuration.");
                }
                return true;
            }
            if (sender instanceof Player) {
                Player player = (Player)sender;
                Serverselector.this.openGUIForPlayer(player);
                return true;
            }
            sender.sendMessage("This command can only be used by players.");
            return false;
        }
    }
}

