/*
 * Decompiled with CFR 0.152.
 */
package com.starmaster.disableriptide;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisableRiptide
extends JavaPlugin
implements Listener {
    private Map<UUID, Long> combatTimestamps;
    private int combatDurationSeconds = 10;

    public void onEnable() {
        this.combatTimestamps = new HashMap<UUID, Long>();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.combatDurationSeconds = this.getConfig().getInt("combat-duration-seconds", 10);
        new BukkitRunnable(){

            public void run() {
                DisableRiptide.this.cleanupExpiredCombat();
            }
        }.runTaskTimer((Plugin)this, 0L, 100L);
        this.getLogger().info("DisableRiptide plugin enabled - Combat duration: " + this.combatDurationSeconds + " seconds");
    }

    public void onDisable() {
        this.getLogger().info("DisableRiptide plugin disabled");
    }

    private void cleanupExpiredCombat() {
        long currentTime = System.currentTimeMillis();
        this.combatTimestamps.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > (long)this.combatDurationSeconds * 1000L);
    }

    private boolean isPlayerInCombat(Player player) {
        Long lastCombatTime = this.combatTimestamps.get(player.getUniqueId());
        if (lastCombatTime == null) {
            return false;
        }
        long timeSinceLastCombat = System.currentTimeMillis() - lastCombatTime;
        return timeSinceLastCombat <= (long)this.combatDurationSeconds * 1000L;
    }

    private void putPlayerInCombat(Player player) {
        this.combatTimestamps.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            Player victim = (Player)event.getEntity();
            Player attacker = (Player)event.getDamager();
            this.putPlayerInCombat(victim);
            this.putPlayerInCombat(attacker);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && item.getType() == Material.TRIDENT && item.containsEnchantment(Enchantment.RIPTIDE) && this.isPlayerInCombat(player)) {
            event.setCancelled(true);
            Long lastCombatTime = this.combatTimestamps.get(player.getUniqueId());
            if (lastCombatTime != null) {
                long timeSinceLastCombat = System.currentTimeMillis() - lastCombatTime;
                long remainingTime = (long)this.combatDurationSeconds * 1000L - timeSinceLastCombat;
                int remainingSeconds = (int)Math.ceil((double)remainingTime / 1000.0);
                player.sendMessage("\u00a7cYou cannot use riptide while in combat! \u00a7e(" + remainingSeconds + "s remaining)");
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.combatTimestamps.remove(event.getPlayer().getUniqueId());
    }
}

