/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.layer;

import com.jahirtrap.critterarmory.init.ModModelLayers;
import com.jahirtrap.critterarmory.util.CommonUtils;
import com.jahirtrap.critterarmory.util.RenderStates;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ChickenRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChickenArmorLayer
extends RenderLayer<ChickenRenderState, ChickenModel> {
    private final ChickenModel adultModel;
    private final ChickenModel babyModel;

    public ChickenArmorLayer(RenderLayerParent<ChickenRenderState, ChickenModel> layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.adultModel = new ChickenModel(modelSet.bakeLayer(ModModelLayers.CHICKEN_ARMOR));
        this.babyModel = new ChickenModel(modelSet.bakeLayer(ModModelLayers.CHICKEN_BABY_ARMOR));
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector collector, int i, ChickenRenderState renderState, float f, float g) {
        if (renderState instanceof RenderStates.Chicken) {
            RenderStates.Chicken armorRenderState = (RenderStates.Chicken)renderState;
            ItemStack stack = armorRenderState.bodyArmorItem;
            Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent()) {
                ChickenModel model = armorRenderState.isBaby ? this.babyModel : this.adultModel;
                CommonUtils.renderArmor((ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().get()), model, armorRenderState, stack, poseStack, collector, i);
            }
        }
    }
}

