/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init;

import com.jahirtrap.critterarmory.init.ModMaterials;
import com.jahirtrap.critterarmory.item.BaseAnimalArmorItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModContent {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"critterarmory");
    public static final List<DeferredItem<Item>> COPPER_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.COPPER, new Item.Properties());
    public static final List<DeferredItem<Item>> IRON_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.IRON, new Item.Properties());
    public static final List<DeferredItem<Item>> GOLD_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.GOLD, new Item.Properties());
    public static final List<DeferredItem<Item>> DIAMOND_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.DIAMOND, new Item.Properties());
    public static final List<DeferredItem<Item>> NETHERITE_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.NETHERITE, new Item.Properties().fireResistant());
    public static final DeferredItem<Item> BALANCED_FEED = ModContent.registerItem("balanced_feed", Item::new, new Item.Properties());
    public static final DeferredItem<Item> VITALITY_FEED = ModContent.registerItem("vitality_feed", Item::new, new Item.Properties());

    private static DeferredItem<Item> registerItem(String name, Function<Item.Properties, Item> function, Item.Properties itemProp) {
        return ITEMS.register(name, () -> (Item)function.apply(itemProp.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"critterarmory", (String)name)))));
    }

    private static List<DeferredItem<Item>> registerMobArmors(Map.Entry<ArmorMaterial, String> entry, Item.Properties itemProp) {
        ArrayList<DeferredItem<Item>> items = new ArrayList<DeferredItem<Item>>();
        if (entry.getKey() != ModMaterials.MobArmor.COPPER.getKey() && entry.getKey() != ModMaterials.MobArmor.IRON.getKey() && entry.getKey() != ModMaterials.MobArmor.GOLD.getKey() && entry.getKey() != ModMaterials.MobArmor.DIAMOND.getKey()) {
            items.add(ModContent.registerItem(entry.getValue() + "_horse_armor", p -> new Item(p.horseArmor((ArmorMaterial)entry.getKey())), itemProp));
        }
        items.add(ModContent.registerItem(entry.getValue() + "_wolf_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.CANINE, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_cat_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.CAT, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_chicken_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.CHICKEN, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_cow_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.COW, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_pig_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.PIG, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_sheep_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.SHEEP, (Item.Properties)p), itemProp));
        return items;
    }

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }
}

