/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.util;

import com.jahirtrap.critterarmory.init.ModConfig;
import com.jahirtrap.critterarmory.init.ModContent;
import com.jahirtrap.critterarmory.init.ModTags;
import com.jahirtrap.critterarmory.item.BaseAnimalArmorItem;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10394;
import net.minecraft.class_11659;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class CommonUtils {
    private static final Map<class_6862<class_1792>, String> entityArmorMap = new HashMap<class_6862<class_1792>, String>();

    public static void addArmorType(class_6862<class_1792> key, String value) {
        entityArmorMap.put(key, value);
    }

    public static String getArmorType(class_1799 stack) {
        return entityArmorMap.entrySet().stream().filter(entry -> stack.method_31573((class_6862)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse("");
    }

    public static <S> void renderArmor(class_5321<class_10394> resourceKey, class_3879<? super S> model, S object, class_1799 stack, class_4587 poseStack, class_11659 collector, int i) {
        if (!ModConfig.renderArmors || !ModConfig.renderCatArmors && stack.method_31573(ModTags.Items.CAT_ARMOR) || !ModConfig.renderChickenArmors && stack.method_31573(ModTags.Items.CHICKEN_ARMOR) || !ModConfig.renderCowArmors && stack.method_31573(ModTags.Items.COW_ARMOR) || !ModConfig.renderPigArmors && stack.method_31573(ModTags.Items.PIG_ARMOR) || !ModConfig.renderSheepArmors && stack.method_31573(ModTags.Items.SHEEP_ARMOR)) {
            return;
        }
        String type = CommonUtils.getArmorType(stack);
        if (!type.isBlank()) {
            class_2960 resource = resourceKey.method_29177().method_45134(path -> "textures/entity/equipment/" + type + "/" + path + ".png");
            collector.method_73489(model, object, poseStack, class_1921.method_25448((class_2960)resource), i, class_4608.field_21444, 0, null);
        }
    }

    public static boolean feedEntity(class_1657 player, class_1268 hand, class_1429 entity) {
        if (!entity.method_73183().method_8608()) {
            class_1799 stack = player.method_5998(hand);
            if (stack.method_31574(ModContent.BALANCED_FEED) && entity.method_6032() < entity.method_6063()) {
                entity.method_6475(player, hand, stack);
                entity.method_6025((float)ModConfig.healAmount);
                return true;
            }
            if (stack.method_31574(ModContent.VITALITY_FEED)) {
                int healthLimit = ModConfig.healthIncreaseLimit;
                if (entity.method_6063() < (float)healthLimit || entity.method_6032() < entity.method_6063()) {
                    entity.method_6475(player, hand, stack);
                    if (entity.method_6063() < (float)healthLimit) {
                        entity.method_5996(class_5134.field_23716).method_6192((double)Math.min(entity.method_6063() + (float)ModConfig.healthIncreaseAmount, (float)healthLimit));
                        entity.method_43077(class_3417.field_14709);
                    }
                    entity.method_6033(entity.method_6063());
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canWearArmor(class_1309 entity) {
        return Arrays.stream(BaseAnimalArmorItem.BodyType.values()).flatMap(bodyType -> bodyType.allowedEntities.method_40239()).anyMatch(holder -> holder.comp_349() == entity.method_5864());
    }

    public static boolean canFeed(class_1309 entity) {
        return CommonUtils.canWearArmor(entity);
    }

    static {
        CommonUtils.addArmorType(ModTags.Items.CAT_ARMOR, "cat_body");
        CommonUtils.addArmorType(ModTags.Items.CHICKEN_ARMOR, "chicken_body");
        CommonUtils.addArmorType(ModTags.Items.COW_ARMOR, "cow_body");
        CommonUtils.addArmorType(ModTags.Items.PIG_ARMOR, "pig_body");
        CommonUtils.addArmorType(ModTags.Items.SHEEP_ARMOR, "sheep_body");
    }
}

