/*
 * Decompiled with CFR 0.152.
 */
package lol.gito.radgyms.common.util.math;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.class_241;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\fJ\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001e\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010\u001bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b!\u0010\u001b\u00a8\u0006#"}, d2={"Llol/gito/radgyms/common/util/math/Vec2i;", "", "", "x", "y", "<init>", "(II)V", "", "(Ljava/lang/Number;Ljava/lang/Number;)V", "", "f", "scale", "(F)Llol/gito/radgyms/common/util/math/Vec2i;", "vec2", "dot", "(Llol/gito/radgyms/common/util/math/Vec2i;)I", "Lnet/minecraft/class_241;", "add", "(Lnet/minecraft/class_241;)Llol/gito/radgyms/common/util/math/Vec2i;", "", "equals", "(Llol/gito/radgyms/common/util/math/Vec2i;)Z", "normalized", "()Llol/gito/radgyms/common/util/math/Vec2i;", "length", "()F", "lengthSquared", "()I", "distanceToSqr", "(Lnet/minecraft/class_241;)F", "negated", "I", "getX", "getY", "Companion", "Rad Gyms [Cobblemon]"})
public final class Vec2i {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    @JvmField
    @NotNull
    public static final Vec2i ZERO = new Vec2i(0, 0);
    @JvmField
    @NotNull
    public static final Vec2i ONE = new Vec2i(1, 1);
    @JvmField
    @NotNull
    public static final Vec2i UNIT_X = new Vec2i(1, 0);
    @JvmField
    @NotNull
    public static final Vec2i NEG_UNIT_X = new Vec2i(-1, 0);
    @JvmField
    @NotNull
    public static final Vec2i UNIT_Y = new Vec2i(0, 1);
    @JvmField
    @NotNull
    public static final Vec2i NEG_UNIT_Y = new Vec2i(0, -1);
    @JvmField
    @NotNull
    public static final Vec2i MAX = new Vec2i(Integer.MAX_VALUE, Integer.MAX_VALUE);
    @JvmField
    @NotNull
    public static final Vec2i MIN = new Vec2i(Integer.MIN_VALUE, Integer.MIN_VALUE);

    public Vec2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public /* synthetic */ Vec2i(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public Vec2i(@NotNull Number x, @NotNull Number y) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Number number = x;
        if (number instanceof Integer) {
            n2 = x.intValue();
        } else if (number instanceof Long) {
            n2 = (int)x.longValue();
        } else if (number instanceof Short) {
            n2 = x.shortValue();
        } else if (number instanceof Byte) {
            n2 = x.byteValue();
        } else if (number instanceof Double) {
            n2 = MathKt.roundToInt((double)x.doubleValue());
        } else if (number instanceof Float) {
            n2 = MathKt.roundToInt((float)x.floatValue());
        } else {
            throw new TypeCastException("Cannot convert X value " + x + " to Int");
        }
        number = y;
        if (number instanceof Integer) {
            n = y.intValue();
        } else if (number instanceof Long) {
            n = (int)y.longValue();
        } else if (number instanceof Short) {
            n = y.shortValue();
        } else if (number instanceof Byte) {
            n = y.byteValue();
        } else if (number instanceof Double) {
            n = MathKt.roundToInt((double)y.doubleValue());
        } else if (number instanceof Float) {
            n = MathKt.roundToInt((float)y.floatValue());
        } else {
            throw new TypeCastException("Cannot convert Y value " + y + " to Int");
        }
        this(n2, n);
    }

    @NotNull
    public final Vec2i scale(float f) {
        return new Vec2i(Float.valueOf((float)this.x * f), Float.valueOf((float)this.y * f));
    }

    public final int dot(@NotNull Vec2i vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"vec2");
        return this.x * vec2.x + this.y * vec2.y;
    }

    @NotNull
    public final Vec2i add(@NotNull class_241 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"vec2");
        return new Vec2i(Float.valueOf((float)this.x + vec2.field_1343), Float.valueOf((float)this.y + vec2.field_1342));
    }

    @NotNull
    public final Vec2i add(float f) {
        return new Vec2i(Float.valueOf((float)this.x + f), Float.valueOf((float)this.y + f));
    }

    public final boolean equals(@NotNull Vec2i vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"vec2");
        return this.x == vec2.x && this.y == vec2.y;
    }

    @NotNull
    public final Vec2i normalized() {
        float f = class_3532.method_15355((float)(this.x * this.x + this.y * this.y));
        return f < 1.0E-4f ? ZERO : new Vec2i(Float.valueOf((float)this.x / f), Float.valueOf((float)this.y / f));
    }

    public final float length() {
        return class_3532.method_15355((float)(this.x * this.x + this.y * this.y));
    }

    public final int lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final float distanceToSqr(@NotNull class_241 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"vec2");
        float f = vec2.field_1343 - (float)this.x;
        float g = vec2.field_1342 - (float)this.y;
        return f * f + g * g;
    }

    @NotNull
    public final Vec2i negated() {
        return new Vec2i(-this.x, -this.y);
    }

    public Vec2i() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006\u00a8\u0006\u000e"}, d2={"Llol/gito/radgyms/common/util/math/Vec2i$Companion;", "", "<init>", "()V", "Llol/gito/radgyms/common/util/math/Vec2i;", "ZERO", "Llol/gito/radgyms/common/util/math/Vec2i;", "ONE", "UNIT_X", "NEG_UNIT_X", "UNIT_Y", "NEG_UNIT_Y", "MAX", "MIN", "Rad Gyms [Cobblemon]"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

