/*
 * Copyright (c) 2025. gitoido-mc
 * This Source Code Form is subject to the terms of the MIT License.
 * If a copy of the MIT License was not distributed with this file,
 * you can obtain one at https://github.com/gitoido-mc/rad-gyms/blob/main/LICENSE.
 *
 */

package lol.gito.radgyms.mixin.client;

import lol.gito.radgyms.client.model.ISpecialItemModel;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_324;
import net.minecraft.class_3695;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@Mixin(class_1088.class)
public abstract class OnLoadModels {

    @Shadow
    @Final
    private Map<class_2960, class_793> jsonUnbakedModels;

    @Shadow
    protected abstract void loadItemModel(class_1091 id);

    @Inject(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", ordinal = 0, shift = At.Shift.AFTER))
    public void init(class_324 blockColors, class_3695 profiler, Map<class_2960, class_793> jsonUnbakedModels,
                     Map<class_2960, List<class_1088.class_9826>> blockStates, CallbackInfo ci) {
        for (class_1792 item : class_7923.field_41178) {
            if (item instanceof ISpecialItemModel loader) {
                Stream<class_2960> filteredUnbakedModels = this.jsonUnbakedModels.keySet().stream()
                        .filter(id -> {
                            String path = id.method_12832();
                            return path.startsWith("models/item/") && path.endsWith(".json");
                        })
                        .map(id -> id.method_45136(id.method_12832().substring(
                                "models/item/".length(), id.method_12832().length() - ".json".length())));

                loader.loadModels(filteredUnbakedModels, this::loadItemModel);
            }
        }
    }

}
