/*
 * Copyright (c) 2025. gitoido-mc
 * This Source Code Form is subject to the terms of the MIT License.
 * If a copy of the MIT License was not distributed with this file,
 * you can obtain one at https://github.com/gitoido-mc/rad-gyms/blob/main/LICENSE.
 *
 */

package lol.gito.radgyms.mixin.client;

import lol.gito.radgyms.RadGyms;
import lol.gito.radgyms.client.RadGymsClient;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_324;
import net.minecraft.class_3695;
import net.minecraft.class_793;
import net.minecraft.class_811;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Mixin(class_1088.class)
public abstract class OnLoadModels {
    @Shadow
    @Final
    private Map<class_2960, class_793> jsonUnbakedModels;

    @Shadow
    protected abstract void loadItemModel(class_1091 id);

    @Inject(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", ordinal = 0, shift = At.Shift.AFTER))
    public void init(
        class_324 blockColors,
        class_3695 profiler,
        Map<class_2960, class_793> jsonUnbakedModels,
        Map<class_2960, List<class_1088.class_9826>> blockStates,
        CallbackInfo ci
    ) {
        this.jsonUnbakedModels.keySet().stream()
            .filter(id -> {
                String path = id.method_12832();
                boolean check = path.startsWith("models/item/gym_key") && path.endsWith(".json");
                if (check) {
                    RadGyms.INSTANCE.getLOGGER().info(path);
                }
                return check;
            })
            .map(id -> id
                .method_45136(
                    id.method_12832()
                        .substring(
                            "models/item/".length(),
                            id.method_12832().length() - ".json".length()
                        )
                )
            )
            .forEach(id -> Arrays.stream(class_811.values())
                .forEach(item ->
                    this.loadItemModel(RadGymsClient.INSTANCE.modModelId(id, item.method_15434()))
                )
            );
    }
}
