/*
 * Copyright (c) 2025. gitoido-mc
 * This Source Code Form is subject to the terms of the MIT License.
 * If a copy of the MIT License was not distributed with this file,
 * you can obtain one at https://github.com/gitoido-mc/rad-gyms/blob/main/LICENSE.
 *
 */

package lol.gito.radgyms.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import lol.gito.radgyms.RadGyms;
import lol.gito.radgyms.client.RadGymsClient;
import lol.gito.radgyms.common.registry.DataComponentRegistry;
import lol.gito.radgyms.common.registry.ItemRegistry;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_763;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

@Mixin(class_918.class)
public abstract class OnRenderItemModel {
    @Shadow
    @Final
    private class_763 models;

    @Inject(
        method = "renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformationMode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z", shift = At.Shift.AFTER)
    )
    private void RadGyms$overrideKeyModel(
        class_1799 stack,
        class_811 renderMode,
        boolean leftHanded,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        int overlay,
        class_1087 model,
        CallbackInfo ci,
        @Local(argsOnly = true) LocalRef<class_1087> override
    ) {
        if (stack.method_31574(ItemRegistry.INSTANCE.getGYM_KEY())
            && stack.method_57824(DataComponentRegistry.INSTANCE.getGYM_TYPE_COMPONENT()) != null
            && !Objects.equals(stack.method_57824(DataComponentRegistry.INSTANCE.getGYM_TYPE_COMPONENT()), "chaos")
        ) {
            String type = stack.method_57824(DataComponentRegistry.INSTANCE.getGYM_TYPE_COMPONENT());
            class_2960 intermediate = RadGyms.INSTANCE.modId("gym_key_" + type);
            class_1092 manager = this.models.method_3303();

            if (!manager
                .method_4742(RadGymsClient.INSTANCE.modModelId(intermediate, renderMode.method_15434()))
                .equals(manager.method_4744())
            ) {
                override.set(manager
                    .method_4742(RadGymsClient.INSTANCE.modModelId(intermediate, renderMode.method_15434()))
                );
            }
        }
    }
}

