/*
 * Decompiled with CFR 0.152.
 */
package lol.gito.radgyms.common.gym;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import lol.gito.radgyms.RadGyms;
import lol.gito.radgyms.api.dto.Gym;
import lol.gito.radgyms.api.dto.TrainerModel;
import lol.gito.radgyms.common.entity.Trainer;
import lol.gito.radgyms.common.gym.GymTemplate;
import lol.gito.radgyms.common.registry.BlockRegistry;
import lol.gito.radgyms.common.registry.DimensionRegistry;
import lol.gito.radgyms.common.registry.EntityRegistry;
import lol.gito.radgyms.common.state.PlayerData;
import lol.gito.radgyms.common.state.RadGymsState;
import lol.gito.radgyms.common.util.SchedulerUtilKt;
import lol.gito.radgyms.common.world.PlayerSpawnHelper;
import lol.gito.radgyms.common.world.StructureManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5250;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJE\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b%\u0010&J!\u0010(\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b(\u0010)R#\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020+0*8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Llol/gito/radgyms/common/gym/GymManager;", "", "<init>", "()V", "", "register", "Lnet/minecraft/class_3222;", "serverPlayer", "Lnet/minecraft/class_3218;", "serverWorld", "", "level", "", "type", "", "initInstance", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3218;ILjava/lang/String;)Z", "Llol/gito/radgyms/common/gym/GymTemplate;", "template", "gymDimension", "Lnet/minecraft/class_2338;", "coords", "", "Ljava/util/UUID;", "Llol/gito/radgyms/api/dto/TrainerModel;", "buildTrainers", "(Llol/gito/radgyms/common/gym/GymTemplate;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Ljava/util/Map;", "trainer", "trainerUUID", "requiredUUID", "Lkotlin/Pair;", "buildTrainerEntity", "(Llol/gito/radgyms/api/dto/TrainerModel;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Ljava/util/UUID;Ljava/util/UUID;)Lkotlin/Pair;", "Llol/gito/radgyms/api/dto/Gym;", "gym", "spawnExitBlock", "(Llol/gito/radgyms/api/dto/Gym;)V", "handleGymLeave", "(Lnet/minecraft/class_3222;)V", "removeCoords", "destructGym", "(Lnet/minecraft/class_3222;Ljava/lang/Boolean;)V", "", "Llol/gito/radgyms/api/dto/Gym$Json;", "GYM_TEMPLATES", "Ljava/util/Map;", "getGYM_TEMPLATES", "()Ljava/util/Map;", "Rad Gyms [Cobblemon]"})
@SourceDebugExtension(value={"SMAP\nGymManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GymManager.kt\nlol/gito/radgyms/common/gym/GymManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n216#2,2:291\n126#2:295\n153#2,3:296\n216#2,2:305\n1869#3,2:293\n1193#3,2:299\n1267#3,4:301\n*S KotlinDebug\n*F\n+ 1 GymManager.kt\nlol/gito/radgyms/common/gym/GymManager\n*L\n123#1:291,2\n156#1:295\n156#1:296,3\n281#1:305,2\n144#1:293,2\n156#1:299,2\n156#1:301,4\n*E\n"})
public final class GymManager {
    @NotNull
    public static final GymManager INSTANCE = new GymManager();
    @NotNull
    private static final Map<String, Gym.Json> GYM_TEMPLATES = new LinkedHashMap();

    private GymManager() {
    }

    @NotNull
    public final Map<String, Gym.Json> getGYM_TEMPLATES() {
        return GYM_TEMPLATES;
    }

    public final void register() {
    }

    public final boolean initInstance(@NotNull class_3222 serverPlayer, @NotNull class_3218 serverWorld, int level, @Nullable String type) {
        String label;
        String string;
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter((Object)serverWorld, (String)"serverWorld");
        class_2960 class_29602 = serverWorld.method_27983().method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getValue(...)");
        class_243 class_2432 = serverPlayer.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
        RadGymsState.Companion.setReturnCoordsForPlayer(serverPlayer, new PlayerData.ReturnCoords(class_29602, Vec3ExtensionsKt.toBlockPos((class_243)class_2432)));
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        int gymLevel = RangesKt.coerceIn((int)level, (ClosedRange)((ClosedRange)new IntRange(5, Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel())));
        MinecraftServer minecraftServer = serverPlayer.method_5682();
        if (minecraftServer == null || (minecraftServer = minecraftServer.method_3847(DimensionRegistry.INSTANCE.getRADGYMS_LEVEL_KEY())) == null) {
            return false;
        }
        MinecraftServer gymDimension = minecraftServer;
        if (Intrinsics.areEqual((Object)serverWorld.method_27983(), DimensionRegistry.INSTANCE.getRADGYMS_LEVEL_KEY())) {
            return false;
        }
        String gymType = CollectionsKt.contains((Iterable)GYM_TEMPLATES.keySet(), (Object)type) ? type : "default";
        RadGyms.INSTANCE.debug("Initializing " + gymType + " template for " + type + " gym");
        RadGyms.INSTANCE.debug("Available templates " + GYM_TEMPLATES.keySet());
        Gym.Json json = GYM_TEMPLATES.get(gymType);
        Intrinsics.checkNotNull((Object)json);
        GymTemplate gym = GymTemplate.INSTANCE.fromGymDto(serverPlayer, json, gymLevel, type);
        class_2338 playerGymCoords = PlayerSpawnHelper.INSTANCE.getUniquePlayerCoords(serverPlayer, (class_3218)gymDimension);
        class_2338 dest = class_2338.method_49637((double)((double)playerGymCoords.method_10263() + gym.getRelativePlayerSpawn().field_1352), (double)((double)playerGymCoords.method_10264() + gym.getRelativePlayerSpawn().field_1351), (double)((double)playerGymCoords.method_10260() + gym.getRelativePlayerSpawn().field_1350));
        RadGyms.INSTANCE.debug("Trying to place gym structure with " + gym.getStructure() + " at " + playerGymCoords.method_10263() + " " + playerGymCoords.method_10264() + " " + playerGymCoords.method_10260() + " ");
        StructureManager.INSTANCE.placeStructure((class_5281)gymDimension, playerGymCoords, gym.getStructure());
        gymDimension.method_14178().method_17297(class_3230.field_19280, gymDimension.method_22350(dest).method_12004(), 4, (Object)dest);
        Intrinsics.checkNotNull((Object)dest);
        PlayerSpawnHelper.INSTANCE.teleportPlayer(serverPlayer, (class_3218)gymDimension, dest, gym.getPlayerYaw(), 0.0f);
        Map<UUID, TrainerModel> trainerUUIDs = this.buildTrainers(gym, (class_3218)gymDimension, playerGymCoords);
        class_5250 chaosTranslatable = class_2561.method_43471((String)RadGyms.INSTANCE.modId("item.component.type.chaos").method_42094());
        String string2 = gymType;
        String string3 = Intrinsics.areEqual((Object)string2, (Object)"default") ? (Intrinsics.areEqual((Object)(string = type), (Object)"default") ? chaosTranslatable.getString() : (string == null ? chaosTranslatable.getString() : class_2561.method_43471((String)MiscUtilsKt.cobblemonResource((String)("type." + type)).method_42094()).getString())) : (label = string2 == null ? chaosTranslatable.getString() : class_2561.method_43471((String)MiscUtilsKt.cobblemonResource((String)("type." + type)).method_42094()).getString());
        String string4 = type;
        if (string4 == null) {
            string4 = "default";
        }
        Intrinsics.checkNotNull((Object)label);
        Gym gymInstance = new Gym(gym, trainerUUIDs, playerGymCoords, gymLevel, string4, label);
        RadGymsState.Companion.addGymForPlayer(serverPlayer, gymInstance);
        TrainerRegistry trainerRegistry = RadGyms.INSTANCE.getRCT().getTrainerRegistry();
        Map<UUID, TrainerModel> $this$forEach$iv = gymInstance.getNpcList();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, TrainerModel>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            TrainerNPC trainer;
            Map.Entry<UUID, TrainerModel> element$iv;
            Map.Entry<UUID, TrainerModel> entry = element$iv = iterator.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            TrainerModel npc = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)trainerRegistry.registerNPC(uuid.toString(), npc.getTrainer()), (String)"registerNPC(...)");
            class_1297 class_12972 = gymDimension.method_14190(uuid);
            Intrinsics.checkNotNull((Object)class_12972, (String)"null cannot be cast to non-null type lol.gito.radgyms.common.entity.Trainer");
            trainer.setEntity((class_1309)((Trainer)class_12972));
        }
        RadGyms.INSTANCE.debug("Gym " + gymType + " initialized, took " + Duration.getInWholeMilliseconds-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime)) + " ms");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UUID, TrainerModel> buildTrainers(GymTemplate template, class_3218 gymDimension, class_2338 coords) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$mapTo$iv$iv;
        Object requiredUUID;
        Map trainerIds = new LinkedHashMap();
        Iterable $this$forEach$iv = template.getTrainers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uUID;
            TrainerModel it = (TrainerModel)element$iv;
            boolean bl = false;
            UUID uuid = UUID.randomUUID();
            if (it.getRequires() != null) {
                Pair pair = (Pair)trainerIds.get(it.getRequires());
                uUID = pair != null ? (UUID)pair.getFirst() : null;
            } else {
                uUID = null;
            }
            requiredUUID = uUID;
            Intrinsics.checkNotNull((Object)uuid);
            Pair<UUID, TrainerModel> entity = INSTANCE.buildTrainerEntity(it, gymDimension, coords, uuid, (UUID)requiredUUID);
            boolean bl2 = false;
            trainerIds.put(it.getId(), entity);
        }
        Object $this$map$iv = trainerIds;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            requiredUUID = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Pair)it.getValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private final Pair<UUID, TrainerModel> buildTrainerEntity(TrainerModel trainer, class_3218 gymDimension, class_2338 coords, UUID trainerUUID, UUID requiredUUID) {
        Trainer trainer2;
        Trainer $this$buildTrainerEntity_u24lambda_u240 = trainer2 = new Trainer(EntityRegistry.INSTANCE.getGYM_TRAINER(), (class_1937)gymDimension);
        boolean bl = false;
        $this$buildTrainerEntity_u24lambda_u240.method_5826(trainerUUID);
        $this$buildTrainerEntity_u24lambda_u240.setGymId(trainer.getId());
        $this$buildTrainerEntity_u24lambda_u240.setLeader(trainer.getLeader());
        $this$buildTrainerEntity_u24lambda_u240.setFormat(trainer.getFormat().name());
        $this$buildTrainerEntity_u24lambda_u240.setTrainerId(trainerUUID);
        $this$buildTrainerEntity_u24lambda_u240.setRequires(requiredUUID);
        $this$buildTrainerEntity_u24lambda_u240.field_6241 = trainer.getNpc().getYaw();
        $this$buildTrainerEntity_u24lambda_u240.field_6283 = trainer.getNpc().getYaw();
        $this$buildTrainerEntity_u24lambda_u240.method_5665(class_2561.method_30163((String)trainer.getNpc().getName()));
        $this$buildTrainerEntity_u24lambda_u240.method_5880(true);
        $this$buildTrainerEntity_u24lambda_u240.method_5971();
        $this$buildTrainerEntity_u24lambda_u240.method_33574(new class_243((double)coords.method_10263() + trainer.getNpc().getRelativePosition().field_1352, (double)coords.method_10264() + trainer.getNpc().getRelativePosition().field_1351, (double)coords.method_10260() + trainer.getNpc().getRelativePosition().field_1350));
        Trainer it = trainer2;
        boolean bl2 = false;
        RadGyms.INSTANCE.debug("Spawning trainer " + it.method_5628() + " at " + it.method_19538().field_1352 + " " + it.method_19538().field_1351 + " " + it.method_19538().field_1350 + " in " + gymDimension.method_27983().method_29177());
        RadGyms.INSTANCE.debug("Selected " + trainer.getFormat() + " battle format for trainer");
        gymDimension.method_8649((class_1297)it);
        Trainer trainerEntity = trainer2;
        return new Pair((Object)trainerEntity.method_5667(), (Object)trainer);
    }

    public final void spawnExitBlock(@NotNull Gym gym) {
        Intrinsics.checkNotNullParameter((Object)gym, (String)"gym");
        class_2338 exitPos = new class_2338((int)((double)gym.getCoords().method_10263() + gym.getTemplate().getRelativeExitBlockSpawn().field_1352), (int)((double)gym.getCoords().method_10264() + gym.getTemplate().getRelativeExitBlockSpawn().field_1351), (int)((double)gym.getCoords().method_10260() + gym.getTemplate().getRelativeExitBlockSpawn().field_1350));
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        Intrinsics.checkNotNull((Object)minecraftServer);
        class_3218 class_32182 = minecraftServer.method_3847(DimensionRegistry.INSTANCE.getRADGYMS_LEVEL_KEY());
        Intrinsics.checkNotNull((Object)class_32182);
        class_3218 world = class_32182;
        world.method_8501(exitPos, BlockRegistry.INSTANCE.getGYM_EXIT().method_9564());
        world.method_8524(exitPos);
    }

    public final void handleGymLeave(@NotNull class_3222 serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        PlayerData state = RadGymsState.Companion.getPlayerState((class_1657)serverPlayer);
        Ref.ObjectRef preloadPos = new Ref.ObjectRef();
        Ref.ObjectRef preloadDim = new Ref.ObjectRef();
        if (state.getReturnCoords() != null) {
            PlayerData.ReturnCoords returnCoords = state.getReturnCoords();
            Intrinsics.checkNotNull((Object)returnCoords);
            preloadPos.element = returnCoords.getPosition();
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            Intrinsics.checkNotNull((Object)minecraftServer);
            PlayerData.ReturnCoords returnCoords2 = state.getReturnCoords();
            Intrinsics.checkNotNull((Object)returnCoords2);
            class_3218 class_32182 = minecraftServer.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)returnCoords2.getDimension()));
            Intrinsics.checkNotNull((Object)class_32182);
            preloadDim.element = class_32182;
        } else {
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            Intrinsics.checkNotNull((Object)minecraftServer);
            class_3218 class_32183 = minecraftServer.method_3847(serverPlayer.method_26281());
            Intrinsics.checkNotNull((Object)class_32183);
            preloadDim.element = class_32183;
            class_2338 class_23382 = serverPlayer.method_26280();
            if (class_23382 == null) {
                class_2338 class_23383 = ((class_3218)preloadDim.element).method_43126();
                class_23382 = class_23383;
                Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"getSpawnPos(...)");
            }
            preloadPos.element = class_23382;
        }
        GymManager.destructGym$default(this, serverPlayer, null, 2, null);
        ((class_3218)preloadDim.element).method_14178().method_17297(class_3230.field_19280, ((class_3218)preloadDim.element).method_22350((class_2338)preloadPos.element).method_12004(), 2, preloadPos.element);
        serverPlayer.method_7353(class_2561.method_30163((String)"5..."), true);
        SchedulerUtilKt.delayExecute(1.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$0(serverPlayer, arg_0)));
        SchedulerUtilKt.delayExecute(2.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$1(serverPlayer, arg_0)));
        SchedulerUtilKt.delayExecute(3.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$2(serverPlayer, arg_0)));
        SchedulerUtilKt.delayExecute(4.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$3(serverPlayer, arg_0)));
        SchedulerUtilKt.delayExecute(5.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$4(serverPlayer, preloadDim, preloadPos, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public final void destructGym(@NotNull class_3222 serverPlayer, @Nullable Boolean removeCoords) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        if (!RadGymsState.Companion.hasGymForPlayer(serverPlayer)) {
            return;
        }
        if (Intrinsics.areEqual((Object)removeCoords, (Object)true)) {
            RadGymsState.Companion.setReturnCoordsForPlayer(serverPlayer, null);
        }
        Gym gym = RadGymsState.Companion.getGymForPlayer(serverPlayer);
        Intrinsics.checkNotNull((Object)gym);
        Gym gym2 = gym;
        class_3218 class_32182 = serverPlayer.field_13995.method_3847(DimensionRegistry.INSTANCE.getRADGYMS_LEVEL_KEY());
        Intrinsics.checkNotNull((Object)class_32182);
        class_3218 world = class_32182;
        Unit unit = gym2.getNpcList();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            RadGyms.INSTANCE.debug("Removing trainer " + it.getValue() + " from registry and detaching associated entity");
            RadGyms.INSTANCE.getRCT().getTrainerRegistry().unregisterById(((UUID)it.getKey()).toString());
            class_1297 class_12972 = world.method_14190((UUID)it.getKey());
            if (class_12972 == null) continue;
            class_12972.method_31472();
        }
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        RadGymsState.Companion.removeGymForPlayer(serverPlayer);
    }

    public static /* synthetic */ void destructGym$default(GymManager gymManager, class_3222 class_32222, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        gymManager.destructGym(class_32222, bl);
    }

    private static final Unit handleGymLeave$lambda$0(class_3222 $serverPlayer, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $serverPlayer.method_7353(class_2561.method_30163((String)"4..."), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$1(class_3222 $serverPlayer, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $serverPlayer.method_7353(class_2561.method_30163((String)"3..."), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$2(class_3222 $serverPlayer, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $serverPlayer.method_7353(class_2561.method_30163((String)"2..."), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$3(class_3222 $serverPlayer, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $serverPlayer.method_7353(class_2561.method_30163((String)"1..."), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$4(class_3222 $serverPlayer, Ref.ObjectRef $preloadDim, Ref.ObjectRef $preloadPos, ScheduledTask it) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PlayerSpawnHelper.INSTANCE.teleportPlayer($serverPlayer, (class_3218)$preloadDim.element, (class_2338)$preloadPos.element, $serverPlayer.method_36454(), $serverPlayer.method_36455());
        Unit it2 = unit = Unit.INSTANCE;
        boolean bl = false;
        RadGyms.INSTANCE.debug("Gym instance removed from memory");
        RadGymsState.Companion.setReturnCoordsForPlayer($serverPlayer, null);
        return Unit.INSTANCE;
    }
}

