/*
 * Decompiled with CFR 0.152.
 */
package lol.gito.radgyms.common.gym;

import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.api.scheduling.SchedulingTracker;
import com.cobblemon.mod.common.api.scheduling.ServerTaskTracker;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import lol.gito.radgyms.RadGyms;
import lol.gito.radgyms.common.entity.Trainer;
import lol.gito.radgyms.common.gym.GymDTO;
import lol.gito.radgyms.common.gym.GymInstance;
import lol.gito.radgyms.common.gym.GymTemplate;
import lol.gito.radgyms.common.gym.GymTrainer;
import lol.gito.radgyms.common.registry.BlockRegistry;
import lol.gito.radgyms.common.registry.DimensionRegistry;
import lol.gito.radgyms.common.registry.EntityRegistry;
import lol.gito.radgyms.common.world.PlayerSpawnHelper;
import lol.gito.radgyms.common.world.StructureManager;
import lol.gito.radgyms.state.PlayerData;
import lol.gito.radgyms.state.RadGymsState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5250;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\r\u0010\u000eJ3\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018JE\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010!J!\u0010$\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b$\u0010%J+\u0010+\u001a\u00020)2\u0006\u0010'\u001a\u00020&2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001f0(H\u0002\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020\u001f\u00a2\u0006\u0004\b-\u0010\u0003R#\u00100\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020/0.8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Llol/gito/radgyms/common/gym/GymManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "serverPlayer", "Lnet/minecraft/class_3218;", "serverWorld", "", "level", "", "type", "", "initInstance", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3218;ILjava/lang/String;)Z", "Llol/gito/radgyms/common/gym/GymTemplate;", "template", "gymDimension", "Lnet/minecraft/class_2338;", "coords", "", "Ljava/util/UUID;", "Llol/gito/radgyms/common/gym/GymTrainer;", "buildTrainers", "(Llol/gito/radgyms/common/gym/GymTemplate;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Ljava/util/Map;", "trainerTemplate", "trainerUUID", "requiredUUID", "Lkotlin/Pair;", "buildTrainerEntity", "(Llol/gito/radgyms/common/gym/GymTrainer;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Ljava/util/UUID;Ljava/util/UUID;)Lkotlin/Pair;", "", "spawnExitBlock", "(Lnet/minecraft/class_3222;)V", "handleGymLeave", "removeCoords", "destructGym", "(Lnet/minecraft/class_3222;Ljava/lang/Boolean;)V", "", "delay", "Lkotlin/Function1;", "Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "execute", "delayExecute", "(FLkotlin/jvm/functions/Function1;)Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "register", "", "Llol/gito/radgyms/common/gym/GymDTO;", "GYM_TEMPLATES", "Ljava/util/Map;", "getGYM_TEMPLATES", "()Ljava/util/Map;", "Rad Gyms [Cobblemon]"})
@SourceDebugExtension(value={"SMAP\nGymManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GymManager.kt\nlol/gito/radgyms/common/gym/GymManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1#2:310\n216#3,2:311\n126#3:315\n153#3,3:316\n216#3,2:325\n1863#4,2:313\n1187#4,2:319\n1261#4,4:321\n*S KotlinDebug\n*F\n+ 1 GymManager.kt\nlol/gito/radgyms/common/gym/GymManager\n*L\n129#1:311,2\n162#1:315\n162#1:316,3\n286#1:325,2\n150#1:313,2\n162#1:319,2\n162#1:321,4\n*E\n"})
public final class GymManager {
    @NotNull
    public static final GymManager INSTANCE = new GymManager();
    @NotNull
    private static final Map<String, GymDTO> GYM_TEMPLATES = new LinkedHashMap();

    private GymManager() {
    }

    @NotNull
    public final Map<String, GymDTO> getGYM_TEMPLATES() {
        return GYM_TEMPLATES;
    }

    public final boolean initInstance(@NotNull class_3222 serverPlayer, @NotNull class_3218 serverWorld, int level, @Nullable String type) {
        String label;
        String string;
        Unit unit;
        GymTemplate gym;
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter((Object)serverWorld, (String)"serverWorld");
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        int gymLevel = RangesKt.coerceIn((int)level, (ClosedRange)((ClosedRange)new IntRange(5, 100)));
        MinecraftServer minecraftServer = serverPlayer.method_5682();
        if (minecraftServer == null || (minecraftServer = minecraftServer.method_3847(DimensionRegistry.INSTANCE.getRADGYMS_LEVEL_KEY())) == null) {
            return false;
        }
        MinecraftServer gymDimension = minecraftServer;
        if (Intrinsics.areEqual((Object)serverWorld.method_27983(), DimensionRegistry.INSTANCE.getRADGYMS_LEVEL_KEY())) {
            return false;
        }
        class_243 pos = serverPlayer.method_19538();
        String gymType = CollectionsKt.contains((Iterable)GYM_TEMPLATES.keySet(), (Object)type) ? type : "default";
        RadGyms.INSTANCE.debug("Initializing " + gymType + " template for " + type + " gym");
        RadGyms.INSTANCE.debug("Available templates " + GYM_TEMPLATES.keySet());
        GymDTO gymDTO = GYM_TEMPLATES.get(gymType);
        if (gymDTO != null) {
            GymDTO it = gymDTO;
            boolean bl = false;
            v2 = GymTemplate.INSTANCE.fromGymDto(serverPlayer, it, gymLevel, type);
        } else {
            v2 = gym = null;
        }
        if (gym == null) {
            RadGyms.INSTANCE.getLOGGER().warn("Gym " + gymType + " could not be initialized, no such type in template registry");
            return false;
        }
        class_2338 coords = PlayerSpawnHelper.INSTANCE.getUniquePlayerCoords(serverPlayer, (class_3218)gymDimension);
        class_2338 dest = class_2338.method_49637((double)((double)coords.method_10263() + gym.getRelativePlayerSpawn().field_1352), (double)((double)coords.method_10264() + gym.getRelativePlayerSpawn().field_1351), (double)((double)coords.method_10260() + gym.getRelativePlayerSpawn().field_1350));
        RadGyms.INSTANCE.debug("Trying to place gym structure with " + gym.getStructure() + " at " + coords.method_10263() + " " + coords.method_10264() + " " + coords.method_10260() + " ");
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        StructureManager.INSTANCE.placeStructure((class_5281)gymDimension, coords, gym.getStructure());
        it = unit = Unit.INSTANCE;
        boolean bl2 = false;
        RadGyms.INSTANCE.debug("return dim " + serverWorld.method_27983().method_29177());
        it = unit = Unit.INSTANCE;
        boolean bl3 = false;
        class_2960 class_29602 = serverWorld.method_27983().method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getValue(...)");
        Intrinsics.checkNotNull((Object)pos);
        RadGymsState.Companion.setReturnCoordsForPlayer(serverPlayer, new PlayerData.ReturnCoords(class_29602, Vec3ExtensionsKt.toBlockPos((class_243)pos)));
        it = unit = Unit.INSTANCE;
        boolean bl4 = false;
        gymDimension.method_14178().method_17297(class_3230.field_19280, gymDimension.method_22350(dest).method_12004(), 4, (Object)dest);
        Intrinsics.checkNotNull((Object)dest);
        PlayerSpawnHelper.INSTANCE.teleportPlayer(serverPlayer, (class_3218)gymDimension, dest, gym.getPlayerYaw(), 0.0f);
        it = unit = Unit.INSTANCE;
        boolean bl5 = false;
        Map<UUID, GymTrainer> trainerUUIDs = INSTANCE.buildTrainers(gym, (class_3218)gymDimension, coords);
        class_5250 chaosTranslatable = class_2561.method_43471((String)RadGyms.INSTANCE.modId("item.component.type.chaos").method_42094());
        String string2 = gymType;
        String string3 = Intrinsics.areEqual((Object)string2, (Object)"default") ? (Intrinsics.areEqual((Object)(string = type), (Object)"default") ? chaosTranslatable.getString() : (string == null ? chaosTranslatable.getString() : class_2561.method_43471((String)MiscUtilsKt.cobblemonResource((String)("type." + type)).method_42094()).getString())) : (label = string2 == null ? chaosTranslatable.getString() : class_2561.method_43471((String)MiscUtilsKt.cobblemonResource((String)("type." + type)).method_42094()).getString());
        String string4 = type;
        if (string4 == null) {
            string4 = "default";
        }
        Intrinsics.checkNotNull((Object)label);
        GymInstance gymInstance = new GymInstance(gym, trainerUUIDs, coords, gymLevel, string4, label);
        RadGymsState.Companion.addGymForPlayer(serverPlayer, gymInstance);
        TrainerRegistry trainerRegistry = RadGyms.INSTANCE.getRCT().getTrainerRegistry();
        Map<UUID, GymTrainer> $this$forEach$iv = gymInstance.getNpcList();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, GymTrainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            TrainerNPC trainer;
            Map.Entry<UUID, GymTrainer> element$iv;
            Map.Entry<UUID, GymTrainer> entry = element$iv = iterator.next();
            boolean bl6 = false;
            UUID uuid = entry.getKey();
            GymTrainer npc = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)trainerRegistry.registerNPC(uuid.toString(), npc.getTrainer()), (String)"registerNPC(...)");
            class_1297 class_12972 = gymDimension.method_14190(uuid);
            Intrinsics.checkNotNull((Object)class_12972, (String)"null cannot be cast to non-null type lol.gito.radgyms.common.entity.Trainer");
            trainer.setEntity((class_1309)((Trainer)class_12972));
        }
        RadGyms.INSTANCE.debug("Gym " + gymType + " initialized, took " + Duration.getInWholeMilliseconds-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime)) + " ms");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UUID, GymTrainer> buildTrainers(GymTemplate template, class_3218 gymDimension, class_2338 coords) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$mapTo$iv$iv;
        Object requiredUUID;
        Map trainerIds = new LinkedHashMap();
        Iterable $this$forEach$iv = template.getTrainers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uUID;
            GymTrainer it = (GymTrainer)element$iv;
            boolean bl = false;
            UUID uuid = UUID.randomUUID();
            if (it.getRequires() != null) {
                Pair pair = (Pair)trainerIds.get(it.getRequires());
                uUID = pair != null ? (UUID)pair.getFirst() : null;
            } else {
                uUID = null;
            }
            requiredUUID = uUID;
            Intrinsics.checkNotNull((Object)uuid);
            Pair<UUID, GymTrainer> entity = INSTANCE.buildTrainerEntity(it, gymDimension, coords, uuid, (UUID)requiredUUID);
            boolean bl2 = false;
            trainerIds.put(it.getId(), entity);
        }
        Object $this$map$iv = trainerIds;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            requiredUUID = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Pair)it.getValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private final Pair<UUID, GymTrainer> buildTrainerEntity(GymTrainer trainerTemplate, class_3218 gymDimension, class_2338 coords, UUID trainerUUID, UUID requiredUUID) {
        Trainer trainer;
        Trainer $this$buildTrainerEntity_u24lambda_u2411 = trainer = new Trainer(EntityRegistry.INSTANCE.getGYM_TRAINER(), (class_1937)gymDimension);
        boolean bl = false;
        $this$buildTrainerEntity_u24lambda_u2411.method_5971();
        $this$buildTrainerEntity_u24lambda_u2411.method_5826(trainerUUID);
        $this$buildTrainerEntity_u24lambda_u2411.field_6241 = trainerTemplate.getNpc().getYaw();
        $this$buildTrainerEntity_u24lambda_u2411.field_6283 = trainerTemplate.getNpc().getYaw();
        $this$buildTrainerEntity_u24lambda_u2411.method_5665(class_2561.method_30163((String)trainerTemplate.getNpc().getName()));
        $this$buildTrainerEntity_u24lambda_u2411.method_5880(true);
        $this$buildTrainerEntity_u24lambda_u2411.method_33574(new class_243((double)coords.method_10263() + trainerTemplate.getNpc().getRelativePosition().field_1352, (double)coords.method_10264() + trainerTemplate.getNpc().getRelativePosition().field_1351, (double)coords.method_10260() + trainerTemplate.getNpc().getRelativePosition().field_1350));
        $this$buildTrainerEntity_u24lambda_u2411.setGymId(trainerTemplate.getId());
        $this$buildTrainerEntity_u24lambda_u2411.setTrainerId(trainerUUID);
        $this$buildTrainerEntity_u24lambda_u2411.setRequires(requiredUUID);
        $this$buildTrainerEntity_u24lambda_u2411.setLeader(trainerTemplate.getLeader());
        $this$buildTrainerEntity_u24lambda_u2411.setFormat(trainerTemplate.getFormat());
        Trainer it = trainer;
        boolean bl2 = false;
        RadGyms.INSTANCE.debug("Spawning trainer " + it.method_5628() + " at " + it.method_19538().field_1352 + " " + it.method_19538().field_1351 + " " + it.method_19538().field_1350 + " in " + gymDimension.method_27983().method_29177());
        RadGyms.INSTANCE.debug("Selected " + trainerTemplate.getFormat() + " battle format for trainer");
        gymDimension.method_8649((class_1297)it);
        Trainer trainerEntity = trainer;
        return new Pair((Object)trainerEntity.method_5667(), (Object)trainerTemplate);
    }

    public final void spawnExitBlock(@NotNull class_3222 serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        if (!RadGymsState.Companion.hasGymForPlayer(serverPlayer)) {
            return;
        }
        GymInstance gymInstance = RadGymsState.Companion.getGymForPlayer(serverPlayer);
        Intrinsics.checkNotNull((Object)gymInstance);
        GymInstance gym = gymInstance;
        class_2338 exitPos = new class_2338((int)((double)gym.getCoords().method_10263() + gym.getTemplate().getRelativeExitBlockSpawn().field_1352), (int)((double)gym.getCoords().method_10264() + gym.getTemplate().getRelativeExitBlockSpawn().field_1351), (int)((double)gym.getCoords().method_10260() + gym.getTemplate().getRelativeExitBlockSpawn().field_1350));
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        Intrinsics.checkNotNull((Object)minecraftServer);
        class_3218 class_32182 = minecraftServer.method_3847(DimensionRegistry.INSTANCE.getRADGYMS_LEVEL_KEY());
        Intrinsics.checkNotNull((Object)class_32182);
        class_3218 world = class_32182;
        world.method_8501(exitPos, BlockRegistry.INSTANCE.getGYM_EXIT().method_9564());
        world.method_8524(exitPos);
    }

    public final void handleGymLeave(@NotNull class_3222 serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        PlayerData state = RadGymsState.Companion.getPlayerState((class_1657)serverPlayer);
        Ref.ObjectRef preloadPos = new Ref.ObjectRef();
        Ref.ObjectRef preloadDim = new Ref.ObjectRef();
        if (state.getReturnCoords() != null) {
            PlayerData.ReturnCoords returnCoords = state.getReturnCoords();
            Intrinsics.checkNotNull((Object)returnCoords);
            preloadPos.element = returnCoords.getPosition();
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            Intrinsics.checkNotNull((Object)minecraftServer);
            PlayerData.ReturnCoords returnCoords2 = state.getReturnCoords();
            Intrinsics.checkNotNull((Object)returnCoords2);
            class_3218 class_32182 = minecraftServer.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)returnCoords2.getDimension()));
            Intrinsics.checkNotNull((Object)class_32182);
            preloadDim.element = class_32182;
        } else {
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            Intrinsics.checkNotNull((Object)minecraftServer);
            class_3218 class_32183 = minecraftServer.method_3847(serverPlayer.method_26281());
            Intrinsics.checkNotNull((Object)class_32183);
            preloadDim.element = class_32183;
            class_2338 class_23382 = serverPlayer.method_26280();
            if (class_23382 == null) {
                class_2338 class_23383 = ((class_3218)preloadDim.element).method_43126();
                class_23382 = class_23383;
                Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"getSpawnPos(...)");
            }
            preloadPos.element = class_23382;
        }
        GymManager.destructGym$default(this, serverPlayer, null, 2, null);
        ((class_3218)preloadDim.element).method_14178().method_17297(class_3230.field_19280, ((class_3218)preloadDim.element).method_22350((class_2338)preloadPos.element).method_12004(), 2, preloadPos.element);
        serverPlayer.method_7353(class_2561.method_30163((String)"5..."), true);
        this.delayExecute(1.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$13(serverPlayer, arg_0)));
        this.delayExecute(2.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$14(serverPlayer, arg_0)));
        this.delayExecute(3.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$15(serverPlayer, arg_0)));
        this.delayExecute(4.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$16(serverPlayer, arg_0)));
        this.delayExecute(5.0f, (Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> GymManager.handleGymLeave$lambda$18(serverPlayer, preloadDim, preloadPos, arg_0)));
    }

    public final void destructGym(@NotNull class_3222 serverPlayer, @Nullable Boolean removeCoords) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        if (!RadGymsState.Companion.hasGymForPlayer(serverPlayer)) {
            return;
        }
        GymInstance gymInstance = RadGymsState.Companion.getGymForPlayer(serverPlayer);
        Intrinsics.checkNotNull((Object)gymInstance);
        GymInstance gym = gymInstance;
        class_3218 class_32182 = serverPlayer.field_13995.method_3847(DimensionRegistry.INSTANCE.getRADGYMS_LEVEL_KEY());
        Intrinsics.checkNotNull((Object)class_32182);
        class_3218 world = class_32182;
        Map<UUID, GymTrainer> $this$forEach$iv = gym.getNpcList();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, GymTrainer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, GymTrainer> element$iv;
            Map.Entry<UUID, GymTrainer> it = element$iv = iterator.next();
            boolean bl = false;
            RadGyms.INSTANCE.debug("Removing trainer " + it.getValue() + " from registry and detaching associated entity");
            RadGyms.INSTANCE.getRCT().getTrainerRegistry().unregisterById(it.getKey().toString());
            class_1297 class_12972 = world.method_14190(it.getKey());
            if (class_12972 == null) continue;
            class_12972.method_31472();
        }
        if (Intrinsics.areEqual((Object)removeCoords, (Object)true)) {
            RadGymsState.Companion.setReturnCoordsForPlayer(serverPlayer, null);
        }
        RadGymsState.Companion.removeGymForPlayer(serverPlayer);
    }

    public static /* synthetic */ void destructGym$default(GymManager gymManager, class_3222 class_32222, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        gymManager.destructGym(class_32222, bl);
    }

    private final ScheduledTask delayExecute(float delay, Function1<? super ScheduledTask, Unit> execute) {
        return new ScheduledTask.Builder().tracker((SchedulingTracker)ServerTaskTracker.INSTANCE).delay(delay).execute(execute).build();
    }

    public final void register() {
        RadGyms.INSTANCE.debug("GymManager init");
    }

    private static final Unit handleGymLeave$lambda$13(class_3222 $serverPlayer, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $serverPlayer.method_7353(class_2561.method_30163((String)"4..."), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$14(class_3222 $serverPlayer, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $serverPlayer.method_7353(class_2561.method_30163((String)"3..."), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$15(class_3222 $serverPlayer, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $serverPlayer.method_7353(class_2561.method_30163((String)"2..."), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$16(class_3222 $serverPlayer, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $serverPlayer.method_7353(class_2561.method_30163((String)"1..."), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$18(class_3222 $serverPlayer, Ref.ObjectRef $preloadDim, Ref.ObjectRef $preloadPos, ScheduledTask it) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PlayerSpawnHelper.INSTANCE.teleportPlayer($serverPlayer, (class_3218)$preloadDim.element, (class_2338)$preloadPos.element, $serverPlayer.method_36454(), $serverPlayer.method_36455());
        Unit it2 = unit = Unit.INSTANCE;
        boolean bl = false;
        RadGyms.INSTANCE.debug("Gym instance removed from memory");
        RadGymsState.Companion.setReturnCoordsForPlayer($serverPlayer, null);
        return Unit.INSTANCE;
    }
}

