/*
 * Copyright (c) 2025. gitoido-mc
 * This Source Code Form is subject to the terms of the GNU General Public License v3.0.
 * If a copy of the GNU General Public License v3.0 was not distributed with this file,
 * you can obtain one at https://github.com/gitoido-mc/rad-gyms/blob/main/LICENSE.
 */

package lol.gito.radgyms.common.block

import com.mojang.serialization.MapCodec
import lol.gito.radgyms.common.RadGyms.debug
import lol.gito.radgyms.common.block.entity.GymExitEntity
import lol.gito.radgyms.common.net.server.payload.OpenGymLeaveScreenS2C
import lol.gito.radgyms.common.registry.RadGymsDimensions
import lol.gito.radgyms.common.registry.RadGymsItems.EXIT_ROPE
import lol.gito.radgyms.common.util.displayClientMessage
import net.minecraft.core.BlockPos
import net.minecraft.network.chat.Component.translatable
import net.minecraft.server.level.ServerPlayer
import net.minecraft.world.InteractionResult
import net.minecraft.world.entity.player.Player
import net.minecraft.world.level.Level
import net.minecraft.world.level.block.BaseEntityBlock
import net.minecraft.world.level.block.RenderShape
import net.minecraft.world.level.block.entity.BlockEntity
import net.minecraft.world.level.block.state.BlockState
import net.minecraft.world.phys.BlockHitResult

class GymExitBlock(properties: Properties) : BaseEntityBlock(properties) {
    override fun getRenderShape(state: BlockState): RenderShape = RenderShape.MODEL

    override fun codec(): MapCodec<out BaseEntityBlock> =
        simpleCodec { properties: Properties -> GymExitBlock(properties) }

    override fun newBlockEntity(pos: BlockPos, state: BlockState): BlockEntity = GymExitEntity(pos, state)

    override fun useWithoutItem(
        state: BlockState,
        world: Level,
        pos: BlockPos,
        player: Player,
        hit: BlockHitResult
    ): InteractionResult {
        if (world.getBlockEntity(pos) !is GymExitEntity) return super.useWithoutItem(state, world, pos, player, hit)
        if (world.isClientSide) return InteractionResult.PASS

        (player as ServerPlayer).also {
            debug("Gym exit block used by player ${it.uuid} at $pos in ${world.dimension()}")

            if (world.dimension() == RadGymsDimensions.RADGYMS_LEVEL_KEY) {
                debug("Client: Opening gym exit screen for ${it.uuid} at $pos in ${world.dimension()}")
                OpenGymLeaveScreenS2C().sendToPlayer(it)
            } else {
                it.displayClientMessage(translatable(EXIT_ROPE.descriptionId.plus(".failed")))
            }
        }

        return InteractionResult.SUCCESS
    }
}
