/*
 * Copyright (c) 2025. gitoido-mc
 * This Source Code Form is subject to the terms of the GNU General Public License v3.0.
 * If a copy of the GNU General Public License v3.0 was not distributed with this file,
 * you can obtain one at https://github.com/gitoido-mc/rad-gyms/blob/main/LICENSE.
 */

package lol.gito.radgyms.mixin.client.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import lol.gito.radgyms.common.RadGyms;
import lol.gito.radgyms.common.registry.RadGymsDataComponents;
import lol.gito.radgyms.common.registry.RadGymsItems;
import lol.gito.radgyms.fabric.client.RadGymsFabricClient;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_763;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9331;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_918.class)
public abstract class OnRenderItemModel {
    @Shadow
    @Final
    private class_763 itemModelShaper;

    @Unique
    @Final
    final private class_9331<String> RadGyms$typeComponent = RadGymsDataComponents.RG_GYM_TYPE_COMPONENT;

    @Inject(
        method = "render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z",
            shift = At.Shift.AFTER
        )
    )
    private void RadGyms$overrideKeyModel(
        class_1799 stack,
        class_811 renderMode,
        boolean leftHanded,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        int overlay,
        class_1087 model,
        CallbackInfo ci,
        @Local(argsOnly = true) LocalRef<class_1087> override
    ) {
        if (stack.method_31573(RadGymsItems.GYM_KEY) && stack.method_57824(RadGyms$typeComponent) != null) {
            String type = stack.method_57824(RadGyms$typeComponent);
            if (type == null) return;

            class_2960 intermediate = RadGyms.INSTANCE.modId("gym_key_" + type);
            class_1092 manager = this.itemModelShaper.method_3303();
            class_1091 id = RadGymsFabricClient.INSTANCE.modModelId(intermediate, renderMode.method_15434());

            if (!manager.method_4742(id).equals(manager.method_4744())) {
                override.set(manager.method_4742(id));
            }
        }
    }
}

