/*
 * Copyright (c) 2025. gitoido-mc
 * This Source Code Form is subject to the terms of the GNU General Public License v3.0.
 * If a copy of the GNU General Public License v3.0 was not distributed with this file,
 * you can obtain one at https://github.com/gitoido-mc/rad-gyms/blob/main/LICENSE.
 */

package lol.gito.radgyms.mixin.server.item;

import lol.gito.radgyms.common.registry.RadGymsDataComponents;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_5536;
import net.minecraft.class_5537;
import net.minecraft.class_5630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5537.class)
public abstract class BundleItemMixin {
    @Inject(method = "dropContents", at = @At("RETURN"), cancellable = true)
    private static void RadGyms$dropAllBundledItems(
        class_1799 itemStack,
        class_1657 player,
        CallbackInfoReturnable<Boolean> cir
    ) {
        Boolean bundleComponent = itemStack.method_57824(RadGymsDataComponents.RG_GYM_BUNDLE_COMPONENT);

        if (!cir.getReturnValue()) {
            return;
        }

        if (bundleComponent != null && player instanceof class_3222) {
            itemStack.method_7934(1);
            cir.setReturnValue(true);
        }
    }

    @Inject(method = "overrideStackedOnOther", at = @At("HEAD"), cancellable = true)
    private void RadGyms$preventOnStackClicked(
        class_1799 itemStack,
        class_1735 slot,
        class_5536 clickAction,
        class_1657 player,
        CallbackInfoReturnable<Boolean> cir
    ) {
        Boolean bundleComponent = itemStack.method_57824(RadGymsDataComponents.RG_GYM_BUNDLE_COMPONENT);

        if (bundleComponent != null) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method = "overrideOtherStackedOnMe", at = @At("HEAD"), cancellable = true)
    private void RadGyms$preventOnClicked(
        class_1799 itemStack,
        class_1799 otherStack,
        class_1735 slot,
        class_5536 clickAction,
        class_1657 player,
        class_5630 slotAccess,
        CallbackInfoReturnable<Boolean> cir
    ) {
        Boolean bundleComponent = itemStack.method_57824(RadGymsDataComponents.RG_GYM_BUNDLE_COMPONENT);
        Boolean bundleOtherComponent = otherStack.method_57824(RadGymsDataComponents.RG_GYM_BUNDLE_COMPONENT);

        if (bundleComponent != null || bundleOtherComponent != null) {
            cir.setReturnValue(false);
        }
    }
}
