/*
 * Copyright (c) 2025. gitoido-mc
 * This Source Code Form is subject to the terms of the GNU General Public License v3.0.
 * If a copy of the GNU General Public License v3.0 was not distributed with this file,
 * you can obtain one at https://github.com/gitoido-mc/rad-gyms/blob/main/LICENSE.
 */

package lol.gito.radgyms.mixin.server.worldBorder;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import lol.gito.radgyms.common.RadGyms;
import lol.gito.radgyms.common.registry.RadGymsDimensions;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_3324.class)
public class PlayerManagerMixin {
    @ModifyExpressionValue(
        method = "sendLevelInfo(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerLevel;)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/server/level/ServerLevel;getWorldBorder()Lnet/minecraft/world/level/border/WorldBorder;"
        )
    )
    private class_2784 sendModifiedBorder(class_2784 original, class_3222 player, class_3218 level) {
        if (level.method_27983() != RadGymsDimensions.RADGYMS_LEVEL_KEY) return original;
        return RadGyms.dimensionWorldBorder;
    }
}
