/*
 * Copyright (c) 2025. gitoido-mc
 * This Source Code Form is subject to the terms of the GNU General Public License v3.0.
 * If a copy of the GNU General Public License v3.0 was not distributed with this file,
 * you can obtain one at https://github.com/gitoido-mc/rad-gyms/blob/main/LICENSE.
 */

package lol.gito.radgyms.mixin.server.worldBorder;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import lol.gito.radgyms.common.RadGyms;
import lol.gito.radgyms.common.registry.RadGymsDimensions;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_3244.class)
public class ServerGamePacketListenerMixin {
    @ModifyReceiver(
        method = "handleInteract(Lnet/minecraft/network/protocol/game/ServerboundInteractPacket;)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/level/border/WorldBorder;isWithinBounds(Lnet/minecraft/core/BlockPos;)Z"
        )
    )
    private class_2784 modifyContains(class_2784 defaultBorder, class_2338 pos) {
        class_3222 player = ((class_3244) (Object) this).field_14140;
        if (player.method_37908().method_27983() != RadGymsDimensions.RADGYMS_LEVEL_KEY) return defaultBorder;
        return RadGyms.dimensionWorldBorder;
    }
}
