/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.text;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public final class FormattedText {
    private static final Map<Character, EnumChatFormatting> reverseMap = new HashMap<Character, EnumChatFormatting>();
    private static final Map<EnumChatFormatting, Color> colorMap = new HashMap<EnumChatFormatting, Color>();
    private static final char ESCAPE = '\u00a7';
    private final String text;
    private final EnumChatFormatting colorStyle;
    private final Set<EnumChatFormatting> fancyStyles = new HashSet<EnumChatFormatting>();
    private final List<FormattedText> siblings = new ArrayList<FormattedText>();
    private final boolean endLine;

    private FormattedText(@NonNull String text, @NonNull EnumChatFormatting colorStyle, @NonNull Set<EnumChatFormatting> fancyStyles, boolean endLine) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (colorStyle == null) {
            throw new NullPointerException("colorStyle is marked non-null but is null");
        }
        if (fancyStyles == null) {
            throw new NullPointerException("fancyStyles is marked non-null but is null");
        }
        this.text = text;
        this.fancyStyles.addAll(fancyStyles);
        this.colorStyle = colorStyle;
        this.endLine = endLine;
    }

    public static FormattedText parse(String text) {
        EnumChatFormatting currentColorStyle = EnumChatFormatting.WHITE;
        HashSet<EnumChatFormatting> currentFancyStyle = new HashSet<EnumChatFormatting>();
        FormattedText result = null;
        StringBuilder accumulator = new StringBuilder();
        int length = text.length();
        boolean format = false;
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (format) {
                EnumChatFormatting f = reverseMap.get(Character.valueOf(c));
                if (f == null) continue;
                if (f == EnumChatFormatting.RESET) {
                    currentColorStyle = EnumChatFormatting.WHITE;
                    currentFancyStyle.clear();
                } else if (f.func_96302_c()) {
                    currentColorStyle = f;
                } else if (f.func_96301_b()) {
                    currentFancyStyle.add(f);
                }
                format = false;
                continue;
            }
            if (c == '\u00a7' || c == '\n') {
                format = c == '\u00a7';
                FormattedText txt = new FormattedText(accumulator.toString(), currentColorStyle, currentFancyStyle, c == '\n');
                if (result == null) {
                    result = txt;
                } else {
                    result.siblings.add(txt);
                }
                accumulator.setLength(0);
                continue;
            }
            accumulator.append(c);
        }
        if (accumulator.length() > 0) {
            FormattedText txt = new FormattedText(accumulator.toString(), currentColorStyle, currentFancyStyle, true);
            if (result == null) {
                result = txt;
            } else {
                result.siblings.add(txt);
            }
        }
        return result;
    }

    public void addChatMessage(ICommandSender target) {
        this.addChatMessage(arg_0 -> ((ICommandSender)target).func_145747_a(arg_0));
    }

    private void addChatMessage(Consumer<IChatComponent> consumer) {
        for (ChatComponentText line : this.toChatText()) {
            consumer.accept((IChatComponent)line);
        }
    }

    public List<ChatComponentText> toChatText() {
        ChatComponentText thisComponent = this.toChatTextSingle();
        ArrayList<ChatComponentText> result = new ArrayList<ChatComponentText>();
        result.add(thisComponent);
        FormattedText prevSibling = this;
        for (FormattedText sibling : this.siblings) {
            ChatComponentText siblingResult = sibling.toChatTextSingle();
            if (prevSibling.endLine) {
                thisComponent = siblingResult;
                result.add(thisComponent);
            } else {
                thisComponent.func_150257_a((IChatComponent)siblingResult);
            }
            prevSibling = sibling;
        }
        return result;
    }

    private ChatComponentText toChatTextSingle() {
        ChatComponentText thisComponent = new ChatComponentText(this.text);
        ChatStyle style = new ChatStyle();
        if (this.colorStyle != null) {
            style.func_150238_a(this.colorStyle);
        }
        for (EnumChatFormatting fancyStyle : this.fancyStyles) {
            switch (fancyStyle) {
                case OBFUSCATED: {
                    style.func_150237_e(Boolean.valueOf(true));
                    break;
                }
                case BOLD: {
                    style.func_150227_a(Boolean.valueOf(true));
                    break;
                }
                case STRIKETHROUGH: {
                    style.func_150225_c(Boolean.valueOf(true));
                    break;
                }
                case UNDERLINE: {
                    style.func_150228_d(Boolean.valueOf(true));
                    break;
                }
                case ITALIC: {
                    style.func_150217_b(Boolean.valueOf(true));
                }
            }
        }
        thisComponent.func_150255_a(style);
        return thisComponent;
    }

    @SideOnly(value=Side.CLIENT)
    public void addChatMessage(EntityOtherPlayerMP target) {
        this.addChatMessage(arg_0 -> ((EntityOtherPlayerMP)target).func_145747_a(arg_0));
    }

    @SideOnly(value=Side.CLIENT)
    public void addChatMessage(EntityPlayerSP target) {
        this.addChatMessage(arg_0 -> ((EntityPlayerSP)target).func_145747_a(arg_0));
    }

    public void addChatMessage(CommandBlockLogic target) {
        this.addChatMessage(arg_0 -> ((CommandBlockLogic)target).func_145747_a(arg_0));
    }

    public void addChatMessage(EntityPlayerMP target) {
        this.addChatMessage(arg_0 -> ((EntityPlayerMP)target).func_145747_a(arg_0));
    }

    public void addChatMessage(RConConsoleSource target) {
        this.addChatMessage(arg_0 -> ((RConConsoleSource)target).func_145747_a(arg_0));
    }

    public void addChatMessage(MinecraftServer target) {
        this.addChatMessage(arg_0 -> ((MinecraftServer)target).func_145747_a(arg_0));
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(FontRenderer renderer, int x, int y) {
        this.draw(renderer, x, y, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(FontRenderer renderer, int x, int y, boolean shadow) {
        int startX = x;
        x = renderer.func_85187_a(this.text, x, y, colorMap.get(this.colorStyle).getRGB(), shadow);
        if (this.endLine) {
            y += renderer.field_78288_b;
            x = startX;
        }
        for (FormattedText sibling : this.siblings) {
            x = renderer.func_85187_a(sibling.text, x, y, colorMap.get(sibling.colorStyle).getRGB(), shadow);
            if (!sibling.endLine) continue;
            y += renderer.field_78288_b;
            x = startX;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawWithShadow(FontRenderer renderer, int x, int y) {
        this.draw(renderer, x, y, true);
    }

    static {
        for (EnumChatFormatting value : EnumChatFormatting.values()) {
            reverseMap.put(Character.valueOf(value.func_96298_a()), value);
            if (value.func_96302_c()) {
                int rgb;
                switch (value.func_96298_a()) {
                    default: {
                        rgb = 0;
                        break;
                    }
                    case '1': {
                        rgb = 170;
                        break;
                    }
                    case '2': {
                        rgb = 43520;
                        break;
                    }
                    case '3': {
                        rgb = 43690;
                        break;
                    }
                    case '4': {
                        rgb = 0xAA0000;
                        break;
                    }
                    case '5': {
                        rgb = 0xAA00AA;
                        break;
                    }
                    case '6': {
                        rgb = 0xFFAA00;
                        break;
                    }
                    case '7': {
                        rgb = 0xAAAAAA;
                        break;
                    }
                    case '8': {
                        rgb = 0x555555;
                        break;
                    }
                    case '9': {
                        rgb = 0x5555FF;
                        break;
                    }
                    case 'a': {
                        rgb = 0x55FF55;
                        break;
                    }
                    case 'b': {
                        rgb = 0x55FFFF;
                        break;
                    }
                    case 'c': {
                        rgb = 0xFF5555;
                        break;
                    }
                    case 'd': {
                        rgb = 0xFF55FF;
                        break;
                    }
                    case 'e': {
                        rgb = 0xFFFF55;
                        break;
                    }
                    case 'f': {
                        rgb = 0xFFFFFF;
                    }
                }
                colorMap.put(value, new Color(rgb));
            }
            try {
                Field colorF = Color.class.getDeclaredField(value.func_96297_d());
                colorMap.put(value, (Color)colorF.get(null));
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }
}

