/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.asm.transformers;

import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class TypeDiscovererModuleInfoSilencer
implements TurboClassTransformer {
    @Override
    public String owner() {
        return "FalsePatternLib";
    }

    @Override
    public String name() {
        return "TypeDiscovererModuleInfoSilencer";
    }

    @Override
    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return "cpw.mods.fml.common.discovery.ITypeDiscoverer".equals(className);
    }

    @Override
    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        for (MethodNode method : cn.methods) {
            if (!method.name.equals("<clinit>")) continue;
            InsnList instructions = method.instructions;
            for (int i = 0; i < instructions.size(); ++i) {
                AbstractInsnNode insn = instructions.get(i);
                if (!(insn instanceof LdcInsnNode)) continue;
                LdcInsnNode ldc = (LdcInsnNode)insn;
                if (!ldc.cst.equals("[^\\s\\$]+(\\$[^\\s]+)?\\.class$")) continue;
                ldc.cst = "(?!module-info)[^\\s\\$]+(\\$[^\\s]+)?\\.class$";
                return true;
            }
        }
        return false;
    }
}

