/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.fields.AListConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraftforge.common.config.Property;

public class DoubleListConfigField
extends AListConfigField<double[], Config.DefaultDoubleList> {
    private final double min;
    private final double max;

    public DoubleListConfigField(ConfigFieldParameters params) throws ConfigException {
        super(params, Property.Type.DOUBLE, Config.DefaultDoubleList.class, Config.DefaultDoubleList::value, Property::setDefaultValues);
        Optional<Config.RangeDouble> range = Optional.ofNullable(this.field.getAnnotation(Config.RangeDouble.class));
        this.min = range.map(Config.RangeDouble::min).orElse(-1.7976931348623157E308);
        this.max = range.map(Config.RangeDouble::max).orElse((Double)Double.MAX_VALUE);
        Property property = this.getProperty();
        property.setMinValue(this.min);
        property.setMaxValue(this.max);
        try {
            if (!property.isDoubleList()) {
                this.setToDefault();
            }
        }
        catch (NullPointerException ignored) {
            this.setToDefault();
        }
        property.comment = property.comment + "\n[range: " + this.min + " ~ " + this.max + ", default: " + Arrays.toString((double[])this.defaultValue) + "]";
    }

    @Override
    protected int length(double[] arr) {
        return arr.length;
    }

    @Override
    protected double[] arrayCopy(double[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    protected void transmitElements(DataOutput output, double[] arr) throws IOException {
        for (double i : arr) {
            output.writeDouble(i);
        }
    }

    @Override
    protected void receiveElements(DataInput input, double[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = input.readDouble();
        }
    }

    @Override
    protected double[] createArray(int length) {
        return new double[length];
    }

    @Override
    public boolean validateField() {
        if (!super.validateField()) {
            return false;
        }
        double[] doubles = (double[])this.getField();
        boolean valid = true;
        for (int j = 0; j < doubles.length; ++j) {
            double d = doubles[j];
            if (!(d < this.min) && !(d > this.max)) continue;
            ConfigValidationFailureEvent.postNumericRangeOutOfBounds(this.field, j, Double.toString(d), Double.toString(this.min), Double.toString(this.max));
            valid = false;
        }
        return valid;
    }

    @Override
    protected double[] getConfig() {
        return this.getProperty().getDoubleList();
    }

    @Override
    protected void putConfig(double[] value) {
        this.getProperty().set(value);
    }

    @Override
    protected double[] getDefault() {
        return Arrays.copyOf((double[])this.defaultValue, ((double[])this.defaultValue).length);
    }
}

