/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Property;

public class StringConfigField
extends AConfigField<String> {
    private final int maxLength;
    private final Pattern pattern;
    private final String defaultValue;

    public StringConfigField(ConfigFieldParameters params) {
        super(params, Property.Type.STRING);
        this.pattern = Optional.ofNullable(this.field.getAnnotation(Config.Pattern.class)).map(ptr -> Pattern.compile(ptr.value())).orElse(null);
        this.defaultValue = Optional.ofNullable(this.field.getAnnotation(Config.DefaultString.class)).map(Config.DefaultString::value).orElseThrow(() -> StringConfigField.noDefault(this.field, "DefaultString"));
        this.maxLength = Optional.ofNullable(this.field.getAnnotation(Config.StringMaxLength.class)).map(Config.StringMaxLength::value).orElse(-1);
        Property property = this.getProperty();
        property.setDefaultValue(this.defaultValue);
        property.comment = property.comment + StringConfigField.generateStringComment(this.maxLength, this.pattern, this.defaultValue);
    }

    public static String generateStringComment(int maxStringLength, Pattern pattern, String defaultValue) {
        StringBuilder cmt = new StringBuilder();
        boolean comma = false;
        if (maxStringLength >= 0) {
            cmt.append("\n[max string length: ").append(maxStringLength);
            comma = true;
        }
        if (pattern != null) {
            if (comma) {
                cmt.append(", ");
            } else {
                cmt.append("\n[");
            }
            cmt.append("pattern: \"").append(pattern.pattern()).append("\"");
            comma = true;
        }
        if (comma) {
            cmt.append(", ");
        } else {
            cmt.append("\n[");
        }
        cmt.append("default: ").append(defaultValue);
        cmt.append("]");
        return cmt.toString();
    }

    public static boolean validateString(String value, int maxLength, Pattern pattern, Field field, int listIndex) {
        if (value == null) {
            ConfigValidationFailureEvent.fieldIsNull(field, listIndex);
            return false;
        }
        if (maxLength >= 0 && value.length() > maxLength) {
            ConfigValidationFailureEvent.postStringSizeOutOfBounds(field, listIndex, value, maxLength);
            return false;
        }
        if (pattern != null && !pattern.matcher(value).matches()) {
            ConfigValidationFailureEvent.postStringPatternMismatch(field, listIndex, value, pattern.pattern());
            return false;
        }
        return true;
    }

    public static void transmitString(DataOutput output, String value) throws IOException {
        output.writeInt(value.length());
        output.writeChars(value);
    }

    public static String receiveString(DataInput input, int maxLength, String valueName, String className) throws IOException {
        int length = input.readInt();
        if (maxLength >= 0 && length > maxLength || length < 0) {
            throw new IOException("Error while retrieving value for " + valueName + " in class " + className + ":\nIllegal string length received!");
        }
        char[] arr = new char[length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = input.readChar();
        }
        return new String(arr);
    }

    @Override
    protected String getField() {
        return (String)this.field.get(null);
    }

    @Override
    protected void putField(String value) {
        this.field.set(null, value);
    }

    @Override
    protected String getConfig() {
        return this.getProperty().getString();
    }

    @Override
    protected void putConfig(String value) {
        this.getProperty().set(value);
    }

    @Override
    protected String getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        return StringConfigField.validateString(this.getField(), this.maxLength, this.pattern, this.field, -1);
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        StringConfigField.transmitString(output, this.getField());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(StringConfigField.receiveString(input, this.maxLength, this.field.getName(), this.field.getDeclaringClass().getName()));
    }
}

