/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.dependencies;

import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.config.EarlyConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class LetsEncryptHelper {
    private static volatile boolean patched = false;

    private LetsEncryptHelper() {
    }

    public static void replaceSSLContext() {
        if (!EarlyConfig.getInstance().enableLetsEncryptRoot()) {
            FPLog.LOG.info("[LetsEncryptHelper] Disabled by config");
            return;
        }
        if (patched) {
            FPLog.LOG.info("[LetsEncryptHelper] Already patched");
            return;
        }
        FPLog.LOG.info("[LetsEncryptHelper] Starting patcher");
        patched = true;
        try (InputStream x1 = LetsEncryptHelper.class.getResourceAsStream("/letsencrypt/isrgrootx1.pem");
             InputStream x2 = LetsEncryptHelper.class.getResourceAsStream("/letsencrypt/isrg-root-x2.pem");){
            KeyStore merged = KeyStore.getInstance(KeyStore.getDefaultType());
            Path cacerts = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            merged.load(Files.newInputStream(cacerts, new OpenOption[0]), "changeit".toCharArray());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cx1 = cf.generateCertificate(x1);
            merged.setCertificateEntry("archaicfix-isrgx1", cx1);
            Certificate cx2 = cf.generateCertificate(x2);
            merged.setCertificateEntry("archaicfix-isrgx2", cx2);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(merged);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
            FPLog.LOG.info("[LetsEncryptHelper] Added certificates to trust store.");
        }
        catch (IOException e) {
            FPLog.LOG.error("[LetsEncryptHelper] Failed to load certificates from classpath.", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            FPLog.LOG.error("[LetsEncryptHelper] Failed to load default keystore.", (Throwable)e);
        }
        catch (Throwable t) {
            FPLog.LOG.error("[LetsEncryptHelper] Unknown error", t);
            throw t;
        }
    }
}

