/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.falsepattern.lib.mixin.ITargetedMod;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface IMixin {
    public String getMixin();

    public Side getSide();

    public Predicate<List<ITargetedMod>> getFilter();

    default public boolean shouldLoad(List<ITargetedMod> loadedMods) {
        Side side = this.getSide();
        return (side == Side.COMMON || side == Side.SERVER && FMLLaunchHandler.side().isServer() || side == Side.CLIENT && FMLLaunchHandler.side().isClient()) && this.getFilter().test(loadedMods);
    }

    public static enum Side {
        COMMON,
        CLIENT,
        SERVER;

    }

    public static final class PredicateHelpers {
        public static Predicate<List<ITargetedMod>> never() {
            return list -> false;
        }

        public static Predicate<List<ITargetedMod>> condition(Supplier<Boolean> condition) {
            return list -> (Boolean)condition.get();
        }

        public static Predicate<List<ITargetedMod>> always() {
            return list -> true;
        }

        public static Predicate<List<ITargetedMod>> require(ITargetedMod mod) {
            return list -> list.contains(mod);
        }

        public static Predicate<List<ITargetedMod>> avoid(ITargetedMod mod) {
            return list -> !list.contains(mod);
        }
    }
}

