/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.falsepattern.lib.mixin.MixinInfoCompatCompanion;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.launchwrapper.Launch;
import org.jetbrains.annotations.ApiStatus;

public final class MixinInfo {
    public static final MixinBootstrapperType mixinBootstrapper;

    public static boolean isMixinsInstalled() {
        return mixinBootstrapper != MixinBootstrapperType.None;
    }

    public static boolean isOfficialSpongeMixins() {
        return mixinBootstrapper == MixinBootstrapperType.SpongeMixins && MixinInfo.getVerUnsafe().equals("0.7.11");
    }

    public static boolean isTamperedSpongeMixins() {
        return mixinBootstrapper == MixinBootstrapperType.SpongeMixins && MixinInfo.getVerUnsafe().equals("0.7.12");
    }

    public static boolean isGrimoire() {
        return mixinBootstrapper == MixinBootstrapperType.Grimoire;
    }

    public static boolean isMixinBooterLegacy() {
        return mixinBootstrapper == MixinBootstrapperType.MixinBooterLegacy;
    }

    public static boolean isGasStation() {
        return mixinBootstrapper == MixinBootstrapperType.GasStation;
    }

    public static boolean isUniMixin() {
        return mixinBootstrapper == MixinBootstrapperType.UniMixin;
    }

    public static MixinBootstrapperType bootstrapperType() {
        return mixinBootstrapper;
    }

    public static Optional<String> mixinVersion() {
        return mixinBootstrapper != MixinBootstrapperType.None ? Optional.of(MixinInfo.getVerUnsafe()) : Optional.empty();
    }

    private static String getVerUnsafe() {
        return "0.8.7";
    }

    @ApiStatus.Internal
    public static boolean isClassPresentSafe(String clazz) {
        try {
            byte[] bytes = Launch.classLoader.getClassBytes(clazz);
            if (bytes == null || bytes.length == 0) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static MixinBootstrapperType detect() {
        if (!MixinInfo.isClassPresentSafe("org.spongepowered.asm.launch.MixinBootstrap")) {
            return MixinBootstrapperType.None;
        }
        for (String candidate : MixinInfoCompatCompanion.UNIMIXIN_CANDIDATES) {
            if (!MixinInfo.isClassPresentSafe(candidate)) continue;
            return MixinBootstrapperType.UniMixin;
        }
        if (MixinInfo.isClassPresentSafe("com.falsepattern.gasstation.GasStation")) {
            return MixinBootstrapperType.GasStation;
        }
        if (MixinInfo.isClassPresentSafe("ru.timeconqueror.spongemixins.core.SpongeMixinsCore")) {
            return MixinBootstrapperType.SpongeMixins;
        }
        if (MixinInfo.isClassPresentSafe("io.github.crucible.grimoire.Grimoire") || MixinInfo.isClassPresentSafe("io.github.crucible.grimoire.common.GrimoireCore")) {
            return MixinBootstrapperType.Grimoire;
        }
        if (MixinInfo.isClassPresentSafe("io.github.tox1cozz.mixinbooterlegacy.MixinBooterLegacyPlugin")) {
            return MixinBootstrapperType.MixinBooterLegacy;
        }
        return MixinBootstrapperType.Other;
    }

    static {
        MixinInfoCompatCompanion.mixinInfoClassLoaded = true;
        mixinBootstrapper = MixinInfo.detect();
    }

    public static enum MixinBootstrapperType {
        None,
        GasStation,
        SpongeMixins,
        Grimoire,
        MixinBooterLegacy,
        Other,
        UniMixin;

    }
}

