/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin.v2;

import com.gtnewhorizon.gtnhmixins.builders.IMixins;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public interface IMixinPlugin<E extends Enum<E>>
extends IMixinConfigPlugin {
    public static Logger createLogger(String modName) {
        return LogManager.getLogger((String)(modName + " Mixin Loader"));
    }

    public Logger getLogger();

    public Class<E> getMixinEnum();

    default public void onLoad(String mixinPackage) {
    }

    @Nullable
    default public String getRefMapperConfig() {
        return null;
    }

    default public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    default public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    default public List<String> getMixins() {
        Logger logger = this.getLogger();
        logger.info("Scanning mixins...");
        try {
            List list = IMixins.getMixins(this.getMixinEnum());
            return list;
        }
        finally {
            logger.info("Mixins scanned.");
        }
    }

    default public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    default public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

