/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin.v2;

import com.falsepattern.lib.mixin.v2.SidedMixins;
import com.falsepattern.lib.mixin.v2.TaggedMod;
import com.gtnewhorizon.gtnhmixins.builders.IBaseTransformer;
import com.gtnewhorizon.gtnhmixins.builders.ITargetMod;
import com.gtnewhorizon.gtnhmixins.builders.MixinBuilder;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MixinHelper {
    @NotNull
    public static MixinBuilder builder(SidedMixins ... mixins) {
        return MixinHelper.builderImpl(null, null, mixins);
    }

    @NotNull
    public static MixinBuilder builder(@Nullable BooleanSupplier cond, SidedMixins ... mixins) {
        return MixinHelper.builderImpl(cond, null, mixins);
    }

    @NotNull
    public static MixinBuilder builder(@NotNull TaggedMod mod, SidedMixins ... mixins) {
        return MixinHelper.builderImpl(null, MixinHelper.mods(mod), mixins);
    }

    @NotNull
    public static MixinBuilder builder(@NotNull TaggedMod @Nullable [] mods, SidedMixins ... mixins) {
        return MixinHelper.builderImpl(null, mods, mixins);
    }

    @NotNull
    public static MixinBuilder builder(@NotNull BooleanSupplier cond, @NotNull TaggedMod mod, SidedMixins ... mixins) {
        return MixinHelper.builderImpl(cond, MixinHelper.mods(mod), mixins);
    }

    @NotNull
    public static MixinBuilder builder(@NotNull BooleanSupplier cond, @NotNull @NotNull TaggedMod @NotNull [] mods, SidedMixins ... mixins) {
        return MixinHelper.builderImpl(cond, mods, mixins);
    }

    @NotNull
    private static MixinBuilder builderImpl(@Nullable BooleanSupplier cond, @NotNull TaggedMod @Nullable [] requiredMods, SidedMixins ... mixins) {
        MixinBuilder builder = new MixinBuilder();
        if (requiredMods != null) {
            for (TaggedMod mod : requiredMods) {
                if (mod.require) {
                    builder.addRequiredMod(mod.mod);
                    continue;
                }
                builder.addExcludedMod(mod.mod);
            }
        }
        for (SidedMixins mixin : mixins) {
            builder.addSidedMixins(mixin.side, mixin.mixins);
        }
        if (cond != null) {
            builder.setApplyIf(cond::getAsBoolean);
        }
        return builder;
    }

    @NotNull
    public static SidedMixins common(String ... mixins) {
        for (int i = 0; i < mixins.length; ++i) {
            mixins[i] = "common." + mixins[i];
        }
        return new SidedMixins(IBaseTransformer.Side.COMMON, mixins);
    }

    @NotNull
    public static SidedMixins client(String ... mixins) {
        for (int i = 0; i < mixins.length; ++i) {
            mixins[i] = "client." + mixins[i];
        }
        return new SidedMixins(IBaseTransformer.Side.CLIENT, mixins);
    }

    @NotNull
    public static SidedMixins server(String ... mixins) {
        for (int i = 0; i < mixins.length; ++i) {
            mixins[i] = "server." + mixins[i];
        }
        return new SidedMixins(IBaseTransformer.Side.SERVER, mixins);
    }

    @NotNull
    public static TaggedMod require(@NotNull ITargetMod mod) {
        return new TaggedMod(true, mod);
    }

    @NotNull
    public static TaggedMod avoid(@NotNull ITargetMod mod) {
        return new TaggedMod(false, mod);
    }

    @NotNull
    public static @NotNull TaggedMod @NotNull [] mods(TaggedMod ... t) {
        return t;
    }
}

