/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.deploader;

import com.gtnewhorizons.retrofuturabootstrap.RfbApiImpl;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.IOUtils;

public final class DeploaderStub {
    private static final String BLACKBOARD_MARKER = "FPLIB_DEPLOADER";
    private static final String BLACKBOARD_RUN_DEPLOADER_MARKER = "FPLIB_RUN_DEPLOADER";
    private static boolean rfbDetected = false;
    private int version = -1;
    private Path path = null;

    public static void bootstrap(boolean rfb) {
        Path deploaderFile;
        Path homeDir;
        Path libDir;
        if (rfb) {
            rfbDetected = true;
            RFBUtil.preinit();
        } else {
            LaunchWrapperUtil.preinit();
        }
        Object deploader = Launch.blackboard.get(BLACKBOARD_MARKER);
        if (deploader != null) {
            return;
        }
        DeploaderStub scanner = new DeploaderStub();
        URLClassLoader cl = DeploaderStub.classLoader();
        for (URL url : cl.getURLs()) {
            try {
                scanner.scanCandidate(new File(url.toURI()).toPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Path mcHomeDir = DeploaderStub.gameDir();
        Path mods = mcHomeDir.resolve("mods");
        Path mods1710 = mods.resolve("1.7.10");
        scanner.scanCandidates(mods);
        scanner.scanCandidates(mods1710);
        if (scanner.path == null) {
            throw new IllegalStateException("Failed to find fplib deploader! Are you sure you bundled it in your jar?");
        }
        String homeDirStr = System.getProperty("minecraft.sharedDataDir");
        if (homeDirStr == null) {
            homeDirStr = System.getenv("MINECRAFT_SHARED_DATA_DIR");
        }
        if (!Files.exists(libDir = (homeDir = homeDirStr == null ? mcHomeDir : Paths.get(homeDirStr, new String[0])).resolve("falsepattern"), new LinkOption[0])) {
            try {
                Files.createDirectories(libDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create directory " + libDir, e);
            }
        }
        if (Files.exists(deploaderFile = libDir.resolve("fplib_deploader.jar"), new LinkOption[0])) {
            try {
                Files.delete(deploaderFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try (OutputStream out = Files.newOutputStream(deploaderFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             JarFile jarIn = new JarFile(scanner.path.toFile());){
            JarEntry theEntry = jarIn.getJarEntry("fplib_deploader.jar");
            IOUtils.copy((InputStream)jarIn.getInputStream(theEntry), (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write deploader jar file!", e);
        }
        try {
            DeploaderStub.addURLToClassPath(deploaderFile.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to add deploader to classpath!", e);
        }
        try {
            Class<?> bootstrap = cl.loadClass("com_falsepattern_deploader_Bootstrap".replace("_", "."));
            Method bootstrapMethod = bootstrap.getDeclaredMethod("bootstrap", Boolean.TYPE, Path.class);
            bootstrapMethod.invoke(null, rfb, mcHomeDir);
            Method runDepLoaderMethod = bootstrap.getDeclaredMethod("runDepLoader", new Class[0]);
            Launch.blackboard.put(BLACKBOARD_MARKER, bootstrap);
            Launch.blackboard.put(BLACKBOARD_RUN_DEPLOADER_MARKER, runDepLoaderMethod);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to load deploader bootstrap class!", e);
        }
    }

    private void scanCandidates(Path dir) {
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            stream.forEach(this::scanCandidate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void scanCandidate(Path file) {
        if (Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".jar")) {
            try (JarFile jarFile = new JarFile(file.toFile());){
                JarEntry entry = jarFile.getJarEntry("fplib_deploader.jar");
                if (entry != null) {
                    int versionInt;
                    JarInputStream jarInput = new JarInputStream(jarFile.getInputStream(entry));
                    while (jarInput.getManifest() == null) {
                        jarInput.getNextJarEntry();
                    }
                    String version = jarInput.getManifest().getMainAttributes().getValue("FPLib-Deploader-Version");
                    if (version != null && (versionInt = Integer.parseInt(version)) > this.version) {
                        this.version = versionInt;
                        this.path = file;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void runDepLoader() {
        Object runDepLoader = Launch.blackboard.get(BLACKBOARD_RUN_DEPLOADER_MARKER);
        if (runDepLoader == null) {
            throw new IllegalStateException("Tried to call runDepLoader without calling bootstrap() first!");
        }
        try {
            ((Method)runDepLoader).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("FalsePatternLib Deploader exited with an exception.", e);
        }
    }

    public static void addURLToClassPath(URL url) {
        if (rfbDetected) {
            RFBUtil.addURLToClassPath(url);
        } else {
            LaunchWrapperUtil.addURLToClassPath(url);
        }
    }

    private static URLClassLoader classLoader() {
        if (rfbDetected) {
            return RFBUtil.classLoader();
        }
        return LaunchWrapperUtil.classLoader();
    }

    public static Path gameDir() {
        if (rfbDetected) {
            return RFBUtil.gameDir();
        }
        return LaunchWrapperUtil.gameDir();
    }

    private static class LaunchWrapperUtil {
        private LaunchWrapperUtil() {
        }

        static void preinit() {
            Launch.classLoader.addTransformerExclusion("com_falsepattern_deploader_".replace('_', '.'));
        }

        static Path gameDir() {
            return Launch.minecraftHome == null ? Paths.get(".", new String[0]) : Launch.minecraftHome.toPath();
        }

        static void addURLToClassPath(URL url) {
            Launch.classLoader.addURL(url);
        }

        static URLClassLoader classLoader() {
            return Launch.classLoader;
        }
    }

    private static class RFBUtil {
        private RFBUtil() {
        }

        static void preinit() {
            ExtensibleClassLoader loader = RfbApiImpl.INSTANCE.launchClassLoader();
            try {
                Method exc = loader.getClass().getDeclaredMethod("addClassLoaderExclusion", String.class);
                exc.invoke((Object)loader, "com_falsepattern_deploader_".replace('_', '.'));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static void addURLToClassPath(URL url) {
            RfbApiImpl.INSTANCE.compatClassLoader().addURL(url);
        }

        static URLClassLoader classLoader() {
            return RfbApiImpl.INSTANCE.compatClassLoader().asURLClassLoader();
        }

        static Path gameDir() {
            return RfbApiImpl.INSTANCE.gameDirectory();
        }
    }
}

