/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.compat;

import com.falsepattern.lib.compat.Rotation;
import com.falsepattern.lib.compat.Vec3i;
import com.falsepattern.lib.util.MathUtil;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={3.class, PooledMutableBlockPos.class, MutableBlockPos.class, 1.class, 2.class})
@Immutable
public class BlockPos
extends Vec3i {
    public static final BlockPos ORIGIN = new BlockPos(0, 0, 0);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int NUM_X_BITS;
    private static final int NUM_Z_BITS;
    private static final int NUM_Y_BITS;
    private static final long Y_MASK;
    private static final int Y_SHIFT;
    private static final int X_SHIFT;
    private static final long Z_MASK;
    private static final long X_MASK;

    public BlockPos(@NonNull Entity source) {
        this(source.field_70165_t, source.field_70163_u, source.field_70161_v);
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
    }

    public BlockPos(double x, double y, double z) {
        super(x, y, z);
    }

    public BlockPos(@NonNull Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
    }

    public BlockPos(@NonNull Vec3i source) {
        this(source.getX(), source.getY(), source.getZ());
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
    }

    public BlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    public static BlockPos fromLong(long serialized) {
        return new BlockPos((int)(serialized << 64 - X_SHIFT - NUM_X_BITS >> 64 - NUM_X_BITS), (int)(serialized << 64 - Y_SHIFT - NUM_Y_BITS >> 64 - NUM_Y_BITS), (int)(serialized << 64 - NUM_Z_BITS >> 64 - NUM_Z_BITS));
    }

    public static Iterable<BlockPos> getAllInBox(@NonNull BlockPos from, @NonNull BlockPos to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        return BlockPos.getAllInBox(Math.min(from.getX(), to.getX()), Math.min(from.getY(), to.getY()), Math.min(from.getZ(), to.getZ()), Math.max(from.getX(), to.getX()), Math.max(from.getY(), to.getY()), Math.max(from.getZ(), to.getZ()));
    }

    public static Iterable<BlockPos> getAllInBox(final int x0, final int y0, final int z0, final int x1, final int y1, final int z1) {
        return () -> new AbstractIterator<BlockPos>(){
            private boolean first = true;
            private int lastX;
            private int lastY;
            private int lastZ;

            protected BlockPos computeNext() {
                if (this.first) {
                    this.first = false;
                    this.lastX = x0;
                    this.lastY = y0;
                    this.lastZ = z0;
                    return new BlockPos(x0, y0, z0);
                }
                if (this.lastX == x1 && this.lastY == y1 && this.lastZ == z1) {
                    return (BlockPos)this.endOfData();
                }
                if (this.lastX < x1) {
                    ++this.lastX;
                } else if (this.lastY < y1) {
                    this.lastX = x0;
                    ++this.lastY;
                } else if (this.lastZ < z1) {
                    this.lastX = x0;
                    this.lastY = y0;
                    ++this.lastZ;
                }
                return new BlockPos(this.lastX, this.lastY, this.lastZ);
            }
        };
    }

    public static Iterable<MutableBlockPos> getAllInBoxMutable(@NonNull BlockPos from, @NonNull BlockPos to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        return BlockPos.getAllInBoxMutable(Math.min(from.getX(), to.getX()), Math.min(from.getY(), to.getY()), Math.min(from.getZ(), to.getZ()), Math.max(from.getX(), to.getX()), Math.max(from.getY(), to.getY()), Math.max(from.getZ(), to.getZ()));
    }

    public static Iterable<MutableBlockPos> getAllInBoxMutable(final int x0, final int y0, final int z0, final int x1, final int y1, final int z1) {
        return () -> new AbstractIterator<MutableBlockPos>(){
            private MutableBlockPos pos;

            protected MutableBlockPos computeNext() {
                if (this.pos == null) {
                    this.pos = new MutableBlockPos(x0, y0, z0);
                    return this.pos;
                }
                if (this.pos.x == x1 && this.pos.y == y1 && this.pos.z == z1) {
                    return (MutableBlockPos)this.endOfData();
                }
                if (this.pos.x < x1) {
                    ++this.pos.x;
                } else if (this.pos.y < y1) {
                    this.pos.x = x0;
                    ++this.pos.y;
                } else if (this.pos.z < z1) {
                    this.pos.x = x0;
                    this.pos.y = y0;
                    ++this.pos.z;
                }
                return this.pos;
            }
        };
    }

    public long toLong() {
        return ((long)this.x & X_MASK) << X_SHIFT | ((long)this.y & Y_MASK) << Y_SHIFT | (long)this.z & Z_MASK;
    }

    public BlockPos add(double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return this;
        }
        return new BlockPos((double)this.x + x, (double)this.y + y, (double)this.z + z);
    }

    public BlockPos add(@NonNull Vec3i vec) {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        return this.add(vec.getX(), vec.getY(), vec.getZ());
    }

    public BlockPos add(int x, int y, int z) {
        if (x == 0 && y == 0 && z == 0) {
            return this;
        }
        return new BlockPos(this.x + x, this.y + y, this.z + z);
    }

    public BlockPos subtract(@NonNull Vec3i vec) {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        return this.add(-vec.getX(), -vec.getY(), -vec.getZ());
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos up(int blocks) {
        return this.offset(EnumFacing.UP, blocks);
    }

    public BlockPos offset(@NonNull EnumFacing facing, int blocks) {
        if (facing == null) {
            throw new NullPointerException("facing is marked non-null but is null");
        }
        if (blocks == 0) {
            return this;
        }
        return new BlockPos(this.x + facing.func_82601_c() * blocks, this.y + facing.func_96559_d() * blocks, this.z + facing.func_82599_e() * blocks);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos down(int blocks) {
        return this.offset(EnumFacing.DOWN, blocks);
    }

    public BlockPos north() {
        return this.north(1);
    }

    public BlockPos north(int blocks) {
        return this.offset(EnumFacing.NORTH, blocks);
    }

    public BlockPos south() {
        return this.south(1);
    }

    public BlockPos south(int blocks) {
        return this.offset(EnumFacing.SOUTH, blocks);
    }

    public BlockPos west() {
        return this.west(1);
    }

    public BlockPos west(int blocks) {
        return this.offset(EnumFacing.WEST, blocks);
    }

    public BlockPos east() {
        return this.east(1);
    }

    public BlockPos east(int blocks) {
        return this.offset(EnumFacing.EAST, blocks);
    }

    public BlockPos offset(@NonNull EnumFacing facing) {
        if (facing == null) {
            throw new NullPointerException("facing is marked non-null but is null");
        }
        return this.offset(facing, 1);
    }

    public BlockPos rotate(@NonNull Rotation rotation) {
        if (rotation == null) {
            throw new NullPointerException("rotation is marked non-null but is null");
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                return new BlockPos(-this.getZ(), this.getY(), this.getX());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-this.getX(), this.getY(), -this.getZ());
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(this.getZ(), this.getY(), -this.getX());
            }
        }
        return this;
    }

    @Override
    public BlockPos crossProduct(@NonNull Vec3i vec) {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        return new BlockPos(this.y * vec.getZ() - this.z * vec.getY(), this.z * vec.getX() - this.x * vec.getZ(), this.x * vec.getY() - this.y * vec.getX());
    }

    public BlockPos toImmutable() {
        return this;
    }

    static {
        NUM_Z_BITS = NUM_X_BITS = 1 + MathUtil.log2(MathUtil.smallestEncompassingPowerOfTwo(30000000));
        NUM_Y_BITS = 64 - NUM_X_BITS - NUM_Z_BITS;
        Y_MASK = (1L << NUM_Y_BITS) - 1L;
        Y_SHIFT = NUM_Z_BITS;
        X_SHIFT = Y_SHIFT + NUM_Y_BITS;
        Z_MASK = (1L << NUM_Z_BITS) - 1L;
        X_MASK = (1L << NUM_X_BITS) - 1L;
    }

    public static /* synthetic */ void jvmdowngrader$nest$com_falsepattern_lib_compat_BlockPos$set$LOGGER(Logger logger) {
        LOGGER = logger;
    }

    @NestHost(value=BlockPos.class)
    public static final class PooledMutableBlockPos
    extends MutableBlockPos {
        private static final List<PooledMutableBlockPos> POOL = new ArrayList<PooledMutableBlockPos>();
        private boolean released;

        private PooledMutableBlockPos(int x, int y, int z) {
            super(x, y, z);
        }

        public static PooledMutableBlockPos retain() {
            return PooledMutableBlockPos.retain(0, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PooledMutableBlockPos retain(int x, int y, int z) {
            List<PooledMutableBlockPos> list = POOL;
            synchronized (list) {
                PooledMutableBlockPos pos;
                if (!POOL.isEmpty() && (pos = POOL.remove(POOL.size() - 1)) != null && pos.released) {
                    pos.released = false;
                    pos.setPos(x, y, z);
                    return pos;
                }
            }
            return new PooledMutableBlockPos(x, y, z);
        }

        public static PooledMutableBlockPos retain(double x, double y, double z) {
            return PooledMutableBlockPos.retain(MathUtil.floor(x), MathUtil.floor(y), MathUtil.floor(z));
        }

        public static PooledMutableBlockPos retain(@NonNull Vec3i vec) {
            if (vec == null) {
                throw new NullPointerException("vec is marked non-null but is null");
            }
            return PooledMutableBlockPos.retain(vec.getX(), vec.getY(), vec.getZ());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            List<PooledMutableBlockPos> list = POOL;
            synchronized (list) {
                if (POOL.size() < 100) {
                    POOL.add(this);
                }
                this.released = true;
            }
        }

        @Override
        public PooledMutableBlockPos setPos(@NonNull Entity entity) {
            if (entity == null) {
                throw new NullPointerException("entity is marked non-null but is null");
            }
            return (PooledMutableBlockPos)super.setPos(entity);
        }

        @Override
        public PooledMutableBlockPos setPos(double x, double y, double z) {
            return (PooledMutableBlockPos)super.setPos(x, y, z);
        }

        @Override
        public PooledMutableBlockPos setPos(int x, int y, int z) {
            if (this.released) {
                LOGGER.error("PooledMutableBlockPosition modified after it was released.", new Throwable());
                this.released = false;
            }
            return (PooledMutableBlockPos)super.setPos(x, y, z);
        }

        @Override
        public PooledMutableBlockPos setPos(@NonNull Vec3i vec) {
            if (vec == null) {
                throw new NullPointerException("vec is marked non-null but is null");
            }
            return (PooledMutableBlockPos)super.setPos(vec);
        }

        @Override
        public PooledMutableBlockPos move(@NonNull EnumFacing facing) {
            if (facing == null) {
                throw new NullPointerException("facing is marked non-null but is null");
            }
            return (PooledMutableBlockPos)super.move(facing);
        }

        @Override
        public PooledMutableBlockPos move(@NonNull EnumFacing facing, int blocks) {
            if (facing == null) {
                throw new NullPointerException("facing is marked non-null but is null");
            }
            return (PooledMutableBlockPos)super.move(facing, blocks);
        }
    }

    @NestHost(value=BlockPos.class)
    public static class MutableBlockPos
    extends BlockPos {
        protected int x;
        protected int y;
        protected int z;

        public MutableBlockPos() {
            this(ORIGIN);
        }

        public MutableBlockPos(@NonNull BlockPos blockPos) {
            this(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            if (blockPos == null) {
                throw new NullPointerException("blockPos is marked non-null but is null");
            }
        }

        public MutableBlockPos(int x, int y, int z) {
            super(ORIGIN);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public BlockPos add(double x, double y, double z) {
            return super.add(x, y, z).toImmutable();
        }

        @Override
        public BlockPos add(int x, int y, int z) {
            return super.add(x, y, z).toImmutable();
        }

        @Override
        public BlockPos offset(@NonNull EnumFacing facing, int blocks) {
            if (facing == null) {
                throw new NullPointerException("facing is marked non-null but is null");
            }
            return super.offset(facing, blocks).toImmutable();
        }

        @Override
        public BlockPos rotate(@NonNull Rotation rotation) {
            if (rotation == null) {
                throw new NullPointerException("rotation is marked non-null but is null");
            }
            return super.rotate(rotation).toImmutable();
        }

        @Override
        public BlockPos toImmutable() {
            return new BlockPos(this);
        }

        public MutableBlockPos setPos(@NonNull Entity entity) {
            if (entity == null) {
                throw new NullPointerException("entity is marked non-null but is null");
            }
            return this.setPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }

        public MutableBlockPos setPos(double x, double y, double z) {
            return this.setPos(MathUtil.floor(x), MathUtil.floor(y), MathUtil.floor(z));
        }

        public MutableBlockPos setPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public MutableBlockPos setPos(@NonNull Vec3i vec) {
            if (vec == null) {
                throw new NullPointerException("vec is marked non-null but is null");
            }
            return this.setPos(vec.getX(), vec.getY(), vec.getZ());
        }

        public MutableBlockPos move(@NonNull EnumFacing facing) {
            if (facing == null) {
                throw new NullPointerException("facing is marked non-null but is null");
            }
            return this.move(facing, 1);
        }

        public MutableBlockPos move(@NonNull EnumFacing facing, int blocks) {
            if (facing == null) {
                throw new NullPointerException("facing is marked non-null but is null");
            }
            return this.setPos(this.x + facing.func_82601_c() * blocks, this.y + facing.func_96559_d() * blocks, this.z + facing.func_82599_e() * blocks);
        }

        @Generated
        public void setX(int x) {
            this.x = x;
        }

        @Generated
        public void setY(int y) {
            this.y = y;
        }

        @Generated
        public void setZ(int z) {
            this.z = z;
        }

        @Override
        @Generated
        public int getX() {
            return this.x;
        }

        @Override
        @Generated
        public int getY() {
            return this.y;
        }

        @Override
        @Generated
        public int getZ() {
            return this.z;
        }
    }
}

