/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.asm.transformers;

import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CrashReportImprover
implements TurboClassTransformer {
    @Override
    public String owner() {
        return "FalsePatternLib";
    }

    @Override
    public String name() {
        return "CrashReportImprover";
    }

    @Override
    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return "net.minecraft.crash.CrashReport".equals(className);
    }

    @Override
    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        block7: for (MethodNode method : cn.methods) {
            switch (method.name) {
                case "saveToFile": 
                case "func_147149_a": {
                    break;
                }
                default: {
                    continue block7;
                }
            }
            ListIterator insnList = method.instructions.iterator();
            while (insnList.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)insnList.next();
                if (insn.getOpcode() != 182 || !(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode call = (MethodInsnNode)insn;
                if (!"java/io/FileWriter".equals(call.owner) || !"close".equals(call.name) || !"()V".equals(call.desc)) continue;
                insnList.previous();
                insnList.add(new InsnNode(89));
                insnList.add(new MethodInsnNode(184, "com/falsepattern/lib/internal/logging/CrashImprover", "injectLatest", "(Ljava/io/FileWriter;)V", false));
                return true;
            }
        }
        return false;
    }
}

