/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.core;

import com.gtnewhorizons.retrofuturabootstrap.RfbApiImpl;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.minecraft.launchwrapper.Launch;
import org.jetbrains.annotations.NotNull;

public final class LowLevelCallMultiplexer {
    private static boolean rfbDetected = false;

    public static void rfbDetected() {
        rfbDetected = true;
    }

    public static void addURLToClassPath(URL url) {
        if (rfbDetected) {
            RFBLowLevel.addURLToClassPath(url);
        } else {
            LaunchWrapperLowLevel.addURLToClassPath(url);
        }
    }

    public static List<URL> getClassPathSources() {
        if (rfbDetected) {
            return RFBLowLevel.getClassPathSources();
        }
        return LaunchWrapperLowLevel.getClassPathSources();
    }

    @NotNull
    public static Path gameDir() {
        if (rfbDetected) {
            return RFBLowLevel.gameDir();
        }
        return LaunchWrapperLowLevel.gameDir();
    }

    public static int javaMajorVersion() {
        if (rfbDetected) {
            return RFBLowLevel.javaMajorVersion();
        }
        return LaunchWrapperLowLevel.javaMajorVersion();
    }

    @Generated
    private LowLevelCallMultiplexer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class RFBLowLevel {
        private RFBLowLevel() {
        }

        static void addURLToClassPath(URL url) {
            RfbApiImpl.INSTANCE.launchClassLoader().addURL(url);
        }

        static List<URL> getClassPathSources() {
            return Arrays.asList(((URLClassLoader)RfbApiImpl.INSTANCE.launchClassLoader()).getURLs());
        }

        @NotNull
        static Path gameDir() {
            return RfbApiImpl.INSTANCE.gameDirectory();
        }

        static int javaMajorVersion() {
            return RfbApiImpl.INSTANCE.javaMajorVersion();
        }
    }

    private static class LaunchWrapperLowLevel {
        private LaunchWrapperLowLevel() {
        }

        static void addURLToClassPath(URL url) {
            Launch.classLoader.addURL(url);
        }

        static List<URL> getClassPathSources() {
            return Launch.classLoader.getSources();
        }

        @NotNull
        static Path gameDir() {
            return Launch.minecraftHome == null ? Paths.get(".", new String[0]) : Launch.minecraftHome.toPath();
        }

        static int javaMajorVersion() {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.")) {
                version = version.substring(2, 3);
            } else {
                int dot = version.indexOf(".");
                if (dot != -1) {
                    version = version.substring(0, dot);
                }
            }
            return Integer.parseInt(version);
        }
    }
}

