/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.internal.impl.config.ConfigElementProxy;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.ConfigurationManagerImpl;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import com.falsepattern.lib.internal.impl.config.fields.BooleanConfigField;
import com.falsepattern.lib.internal.impl.config.fields.BooleanListConfigField;
import com.falsepattern.lib.internal.impl.config.fields.DoubleConfigField;
import com.falsepattern.lib.internal.impl.config.fields.DoubleListConfigField;
import com.falsepattern.lib.internal.impl.config.fields.EnumConfigField;
import com.falsepattern.lib.internal.impl.config.fields.IntConfigField;
import com.falsepattern.lib.internal.impl.config.fields.IntListConfigField;
import com.falsepattern.lib.internal.impl.config.fields.StringConfigField;
import com.falsepattern.lib.internal.impl.config.fields.StringListConfigField;
import cpw.mods.fml.client.config.IConfigElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ParsedConfiguration {
    private static final Map<Class<?>, FieldRefConstructor> constructors = new HashMap();
    public final Class<?> configClass;
    public final String modid;
    public final String category;
    public final String comment;
    public final String langKey;
    public final Configuration rawConfig;
    public final boolean sync;
    private final Map<String, AConfigField<?>> fields = new HashMap();
    private final Map<String, IConfigElement<?>> elements = new HashMap();
    private int maxFieldNameLength;

    public static ParsedConfiguration parseConfig(Class<?> configClass) throws ConfigException {
        Configuration rawConfig;
        String langKey;
        String comment;
        String category;
        Config cfg;
        block12: {
            cfg = Optional.ofNullable(configClass.getAnnotation(Config.class)).orElseThrow(() -> new ConfigException("Class " + configClass.getName() + " does not have a @Config annotation!"));
            category = Optional.of(cfg.category().trim()).map(cat -> cat.isEmpty() ? null : cat).orElseThrow(() -> new ConfigException("Config class " + configClass.getName() + " has an empty category!"));
            comment = Optional.ofNullable(configClass.getAnnotation(Config.Comment.class)).map(Config.Comment::value).map(lines -> String.join((CharSequence)"\n", lines)).orElse("");
            langKey = Optional.ofNullable(configClass.getAnnotation(Config.LangKey.class)).map(Config.LangKey::value).map(x -> x.isEmpty() ? "config." + cfg.modid() + "." + category : x).orElse(category);
            String path = Optional.of(cfg.customPath().trim()).map(p -> p.isEmpty() ? null : p).orElse(cfg.modid());
            rawConfig = ConfigurationManagerImpl.getForgeConfig(path, true);
            if (!rawConfig.hasCategory(category)) {
                ArrayList<String> categoryCandidates = new ArrayList<String>(Arrays.asList(cfg.categoryMigrations()));
                categoryCandidates.add(0, category);
                for (String migration : cfg.pathMigrations()) {
                    migration = migration.trim();
                    try {
                        Configuration oldConfig = ConfigurationManagerImpl.getForgeConfig(migration, false);
                        for (String fromCategory : categoryCandidates) {
                            if (!oldConfig.hasCategory(fromCategory)) continue;
                            ConfigCategory oldCat = oldConfig.getCategory(fromCategory);
                            ConfigCategory newCat = rawConfig.getCategory(category);
                            Set entries = oldCat.keySet();
                            for (String entry : entries) {
                                newCat.put(entry, oldCat.get(entry));
                            }
                            rawConfig.save();
                            oldConfig.removeCategory(oldConfig.getCategory(category));
                            if (oldConfig.getCategoryNames().isEmpty()) {
                                oldConfig.getConfigFile().delete();
                            } else {
                                oldConfig.save();
                            }
                            break block12;
                        }
                    }
                    catch (ConfigException oldConfig) {
                        // empty catch block
                    }
                }
                categoryCandidates.remove(0);
                for (String fromCategory : categoryCandidates) {
                    if (!rawConfig.hasCategory(fromCategory)) continue;
                    ConfigCategory oldCategory = rawConfig.getCategory(fromCategory);
                    ConfigCategory newCategory = rawConfig.getCategory(category);
                    Set entries = oldCategory.keySet();
                    for (String entry : entries) {
                        newCategory.put(entry, oldCategory.get(entry));
                    }
                    rawConfig.removeCategory(oldCategory);
                    break;
                }
            }
        }
        rawConfig.setCategoryComment(category, comment);
        rawConfig.setCategoryLanguageKey(category, langKey);
        ParsedConfiguration parsedConfig = new ParsedConfiguration(configClass, cfg.modid(), category, comment, langKey, rawConfig, configClass.isAnnotationPresent(Config.Synchronize.class));
        try {
            parsedConfig.reloadFields();
        }
        catch (IllegalAccessException e) {
            throw new ConfigException(e);
        }
        return parsedConfig;
    }

    public void saveFile() {
        this.saveFields();
        this.rawConfig.save();
    }

    public void saveFields() {
        for (AConfigField<?> field : this.fields.values()) {
            field.save();
        }
    }

    public void configChanged() {
        for (AConfigField<?> field : this.fields.values()) {
            field.load();
        }
        this.rawConfig.save();
    }

    public void loadFile() throws ConfigException {
        ConfigurationManagerImpl.loadRawConfig(this.rawConfig);
        this.loadFields();
    }

    public void loadFields() {
        for (AConfigField<?> field : this.fields.values()) {
            field.load();
        }
    }

    public void receive(DataInput input) throws IOException {
        if (this.sync) {
            HashMap syncFields = new HashMap(this.fields);
            for (String key : this.fields.keySet()) {
                if (!syncFields.get((Object)key).noSync) continue;
                syncFields.remove(key);
            }
            while (!syncFields.isEmpty()) {
                String fieldName = StringConfigField.receiveString(input, this.maxFieldNameLength, "field name", this.configClass.getName());
                if (!syncFields.containsKey(fieldName)) {
                    throw new IOException("Invalid sync field name received: " + fieldName + " for config class " + this.configClass.getName());
                }
                syncFields.remove(fieldName).receive(input);
            }
        }
    }

    public void transmit(DataOutput output) throws IOException {
        if (this.sync) {
            HashMap syncFields = new HashMap(this.fields);
            for (String string : this.fields.keySet()) {
                if (!syncFields.get((Object)string).noSync) continue;
                syncFields.remove(string);
            }
            for (Map.Entry entry : syncFields.entrySet()) {
                StringConfigField.transmitString(output, (String)entry.getKey());
                ((AConfigField)entry.getValue()).transmit(output);
            }
        }
    }

    public void reloadFields() throws ConfigException, IllegalAccessException {
        this.fields.clear();
        this.maxFieldNameLength = 0;
        ConfigCategory cat = this.rawConfig.getCategory(this.category);
        if (this.configClass.isAnnotationPresent(Config.RequiresWorldRestart.class)) {
            cat.setRequiresWorldRestart(true);
        }
        if (this.configClass.isAssignableFrom(Config.RequiresMcRestart.class)) {
            cat.setRequiresMcRestart(true);
        }
        HashSet nonFoundKeys = new HashSet(this.rawConfig.getCategory(this.category).keySet());
        for (Field field : this.configClass.getDeclaredFields()) {
            AConfigField<?> configField;
            if (field.getAnnotation(Config.Ignore.class) != null || (field.getModifiers() & 0x10) != 0) continue;
            field.setAccessible(true);
            this.maxFieldNameLength = Math.max(this.maxFieldNameLength, field.getName().length());
            Class<?> fieldClass = field.getType();
            Optional<Config.Name> nameAnnotation = Optional.ofNullable(field.getAnnotation(Config.Name.class));
            String name = nameAnnotation.map(Config.Name::value).orElse(field.getName());
            if (!cat.containsKey(name) && nameAnnotation.isPresent()) {
                String[] migrations;
                for (String migration : migrations = nameAnnotation.get().migrations()) {
                    if (migration.isEmpty()) {
                        migration = field.getName();
                    }
                    if (!cat.containsKey(migration)) continue;
                    Property prop2 = cat.remove((Object)migration);
                    prop2.setName(name);
                    cat.put(name, prop2);
                    nonFoundKeys.remove(migration);
                    break;
                }
            } else {
                nonFoundKeys.remove(name);
            }
            ConfigFieldParameters params = new ConfigFieldParameters(field, this.rawConfig, this.modid, this.category);
            if (constructors.containsKey(fieldClass)) {
                configField = constructors.get(fieldClass).construct(params);
                this.fields.put(name, configField);
            } else if (fieldClass.isEnum()) {
                configField = new EnumConfigField(params);
                this.fields.put(name, configField);
            } else {
                throw new ConfigException("Illegal config field: " + field.getName() + " in " + this.configClass.getName() + ": Unsupported type " + fieldClass.getName() + "! Did you forget an @Ignore annotation?");
            }
            configField.init();
            this.elements.computeIfAbsent(name, name2 -> new ConfigElementProxy(configField::getProperty, configField.getComment(), () -> {
                configField.load();
                configField.save();
            }));
        }
        ConfigCategory rawCategory = this.rawConfig.getCategory(this.category);
        for (String key : nonFoundKeys) {
            rawCategory.remove((Object)key);
        }
        this.saveFile();
        this.rawConfig.setCategoryPropertyOrder(this.category, this.fieldsSorted().map(prop -> prop.name).collect(Collectors.toList()));
    }

    private Stream<AConfigField<?>> fieldsSorted() {
        return this.fields.values().stream().sorted(Comparator.comparingInt(prop -> prop.order));
    }

    public List<IConfigElement> getConfigElements() {
        return this.fieldsSorted().map(field -> this.elements.get(field.name)).collect(Collectors.toList());
    }

    public boolean requiresWorldRestart() {
        return this.rawConfig.getCategory(this.category).requiresWorldRestart();
    }

    public boolean requiresMcRestart() {
        return this.rawConfig.getCategory(this.category).requiresMcRestart();
    }

    public boolean validate(BiConsumer<Class<?>, Field> invalidFieldHandler, boolean resetInvalid) {
        boolean valid = true;
        for (AConfigField<?> field : this.fields.values()) {
            if (field.validateField()) continue;
            if (resetInvalid) {
                field.setToDefault();
            }
            invalidFieldHandler.accept(this.configClass, field.getJavaField());
            valid = false;
        }
        return valid;
    }

    @Generated
    private ParsedConfiguration(Class<?> configClass, String modid, String category, String comment, String langKey, Configuration rawConfig, boolean sync) {
        this.configClass = configClass;
        this.modid = modid;
        this.category = category;
        this.comment = comment;
        this.langKey = langKey;
        this.rawConfig = rawConfig;
        this.sync = sync;
    }

    static {
        constructors.put(Boolean.class, BooleanConfigField::new);
        constructors.put(Boolean.TYPE, BooleanConfigField::new);
        constructors.put(Integer.class, IntConfigField::new);
        constructors.put(Integer.TYPE, IntConfigField::new);
        constructors.put(Double.class, DoubleConfigField::new);
        constructors.put(Double.TYPE, DoubleConfigField::new);
        constructors.put(String.class, StringConfigField::new);
        constructors.put(boolean[].class, BooleanListConfigField::new);
        constructors.put(int[].class, IntListConfigField::new);
        constructors.put(double[].class, DoubleListConfigField::new);
        constructors.put(String[].class, StringListConfigField::new);
    }

    private static interface FieldRefConstructor {
        public AConfigField<?> construct(ConfigFieldParameters var1) throws ConfigException;
    }
}

