/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.config.event;

import com.falsepattern.lib.internal.EventUtil;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@SideOnly(value=Side.CLIENT)
@NestMembers(value={End.class, Start.class})
public class ConfigSyncEvent
extends Event {
    public final Class<?> configClass;

    @ApiStatus.Internal
    public ConfigSyncEvent(Class<?> configClass) {
        this.configClass = configClass;
    }

    @ApiStatus.Internal
    public static boolean postStart(Class<?> configClass) {
        Start event = new Start(configClass);
        return EventUtil.postOnCommonBus(event);
    }

    @ApiStatus.Internal
    public static void postEndSuccess(Class<?> configClass) {
        EventUtil.postOnCommonBus(new End(configClass, true, null));
    }

    @ApiStatus.Internal
    public static void postEndFailure(Class<?> configClass, Throwable error) {
        EventUtil.postOnCommonBus(new End(configClass, false, error));
    }

    @SideOnly(value=Side.CLIENT)
    @NestHost(value=ConfigSyncEvent.class)
    public static final class Start
    extends ConfigSyncEvent {
        @ApiStatus.Internal
        public Start(Class<?> configClass) {
            super(configClass);
        }

        public boolean isCancelable() {
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @NestHost(value=ConfigSyncEvent.class)
    public static final class End
    extends ConfigSyncEvent {
        public final boolean successful;
        public final Throwable error;

        @ApiStatus.Internal
        public End(Class<?> configClass, boolean successful, Throwable error) {
            super(configClass);
            this.successful = successful;
            this.error = error;
        }
    }
}

