/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraftforge.common.config.Property;

public class EnumConfigField<T extends Enum<T>>
extends AConfigField<T> {
    private final int maxLength;
    private final Class<T> enumClass;
    private final T defaultValue;
    private final BiMap<String, T> enumNameMap = HashBiMap.create();

    public EnumConfigField(ConfigFieldParameters params) {
        super(params, Property.Type.STRING);
        this.enumClass = this.field.getType();
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (Enum e : (Enum[])this.enumClass.getEnumConstants()) {
            sj.add(e.name());
            this.enumNameMap.put((Object)e.name(), (Object)e);
        }
        this.defaultValue = Optional.ofNullable(this.field.getAnnotation(Config.DefaultEnum.class)).map(Config.DefaultEnum::value).map(defName -> this.enumNameMap.values().stream().filter(e -> e.name().equals(defName)).findAny().orElseThrow(() -> new IllegalArgumentException(EnumConfigField.jvmdowngrader$concat$lambda$new$1$1(defName, this.enumClass.getName())))).orElseThrow(() -> EnumConfigField.noDefault(this.field, "DefaultEnum"));
        this.maxLength = this.enumNameMap.keySet().stream().mapToInt(String::length).max().orElse(0);
        Property property = this.getProperty();
        property.setDefaultValue(((Enum)this.defaultValue).name());
        property.setValidValues(this.enumNameMap.keySet().toArray(new String[0]));
        if (!this.enumNameMap.containsValue(this.getConfig())) {
            this.setToDefault();
        }
        property.comment = EnumConfigField.jvmdowngrader$concat$$init$$1(property.comment, String.valueOf(this.defaultValue), String.valueOf(sj));
    }

    public static void transmitString(DataOutput output, String value) throws IOException {
        output.writeInt(value.length());
        output.writeChars(value);
    }

    public static String receiveString(DataInput input, int maxLength, String fieldName, String className) throws IOException {
        int length = input.readInt();
        if (length > maxLength || length < 0) {
            throw new IOException(EnumConfigField.jvmdowngrader$concat$receiveString$1(fieldName, className));
        }
        char[] arr = new char[length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = input.readChar();
        }
        return new String(arr);
    }

    private T getEnumByName(String name) {
        if (!this.enumNameMap.containsKey((Object)name)) {
            FPLog.LOG.warn("Invalid value {} for enum configuration field {} of type {} in config class {}! Using default value of {}!", new Object[]{name, this.field.getName(), this.enumClass.getName(), this.field.getDeclaringClass().getName(), ((Enum)this.defaultValue).name()});
            return this.defaultValue;
        }
        return (T)((Enum)this.enumNameMap.get((Object)name));
    }

    @Override
    protected T getField() {
        return (T)((Enum)this.enumClass.cast(this.field.get(null)));
    }

    @Override
    protected void putField(T value) {
        this.field.set(null, value);
    }

    @Override
    protected T getConfig() {
        return this.getEnumByName(this.getProperty().getString());
    }

    @Override
    protected void putConfig(T value) {
        this.getProperty().set(((Enum)value).name());
    }

    @Override
    protected T getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        if (this.getField() == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        return true;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        EnumConfigField.transmitString(output, ((Enum)this.getField()).name());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(this.getEnumByName(EnumConfigField.receiveString(input, this.maxLength, this.field.getName(), this.field.getDeclaringClass().getName())));
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string, String string2, String string3) {
        return string + "\n[default: " + string2 + ", possible values: " + string3 + "]";
    }

    private static /* synthetic */ String jvmdowngrader$concat$receiveString$1(String string, String string2) {
        return "Error while retrieving config value for field " + string + " in class " + string2 + ":\nIllegal string length received!";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$1$1(String string, String string2) {
        return "Default value \"" + string + "\" was not found in enum " + string2;
    }
}

