/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.toast;

import com.falsepattern.lib.internal.config.ToastConfig;
import com.falsepattern.lib.toasts.IToast;
import com.falsepattern.lib.util.MathUtil;
import com.google.common.collect.Queues;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.opengl.GL11;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@SideOnly(value=Side.CLIENT)
@NestMembers(value={ToastInstance.class})
public class GuiToastImpl
extends Gui {
    private static GuiToastImpl instance;
    private final Minecraft mc;
    private final Deque<IToast> toastsQueue = Queues.newArrayDeque();
    private ToastInstance<?>[] visible = new ToastInstance[0];

    public GuiToastImpl(Minecraft mcIn) {
        this.mc = mcIn;
    }

    public static void initialize(Minecraft mc) {
        if (instance != null) {
            return;
        }
        instance = new GuiToastImpl(mc);
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    public static GuiToastImpl getInstance() {
        return instance;
    }

    @SubscribeEvent
    public void updateToasts(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.mc.field_71424_I.func_76320_a("toasts");
        this.drawToast(new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d));
        this.mc.field_71424_I.func_76319_b();
    }

    public void drawToast(ScaledResolution resolution) {
        if (!this.mc.field_71474_y.field_74319_N) {
            RenderHelper.func_74518_a();
            if (ToastConfig.MAX_VISIBLE != this.visible.length) {
                this.visible = Arrays.copyOf(this.visible, ToastConfig.MAX_VISIBLE);
            }
            for (int i = 0; i < this.visible.length; ++i) {
                ToastInstance<?> toast = this.visible[i];
                if (toast != null && toast.render(ToastConfig.leftAlign() ? 0 : resolution.func_78326_a(), i)) {
                    this.visible[i] = null;
                }
                if (this.visible[i] != null || this.toastsQueue.isEmpty()) continue;
                this.visible[i] = new ToastInstance(this, this.toastsQueue.removeFirst());
            }
        }
    }

    @Nullable
    public <T extends IToast> T getToast(Class<? extends T> toastClass, Object type) {
        for (ToastInstance<?> toast : this.visible) {
            if (toast == null || !toastClass.isAssignableFrom(toast.getToast().getClass()) || !toast.getToast().getType().equals(type)) continue;
            return (T)((IToast)toastClass.cast(toast));
        }
        for (IToast toast : this.toastsQueue) {
            if (!toastClass.isAssignableFrom(toast.getClass()) || !toast.getType().equals(type)) continue;
            return (T)((IToast)toastClass.cast(toast));
        }
        return null;
    }

    public void clear() {
        Arrays.fill(this.visible, null);
        this.toastsQueue.clear();
    }

    public void add(IToast toastIn) {
        this.toastsQueue.add(toastIn);
    }

    public Minecraft getMinecraft() {
        return this.mc;
    }

    public /* synthetic */ Minecraft jvmdowngrader$nest$com_falsepattern_lib_internal_impl_toast_GuiToastImpl$get$mc() {
        return this.mc;
    }

    public /* synthetic */ void jvmdowngrader$nest$com_falsepattern_lib_internal_impl_toast_GuiToastImpl$set$mc(Minecraft minecraft) {
        this.mc = minecraft;
    }

    @SideOnly(value=Side.CLIENT)
    @NestHost(value=GuiToastImpl.class)
    static class ToastInstance<T extends IToast> {
        private final T toast;
        private long animationTime = -1L;
        private long visibleTime = -1L;
        private IToast.Visibility visibility = IToast.Visibility.SHOW;
        final /* synthetic */ GuiToastImpl this$0;

        ToastInstance(T toastIn) {
            this.this$0 = this$0;
            this.toast = toastIn;
        }

        public T getToast() {
            return this.toast;
        }

        private float getVisibility(long currentTime) {
            float visibility = MathUtil.clamp((float)(currentTime - this.animationTime) / 600.0f, 0.0f, 1.0f);
            visibility *= visibility;
            return this.visibility == IToast.Visibility.HIDE ? 1.0f - visibility : visibility;
        }

        public boolean render(int x, int y) {
            long sysTime = Minecraft.func_71386_F();
            if (this.animationTime == -1L) {
                this.animationTime = sysTime;
                this.visibility.playSound(this.this$0.jvmdowngrader$nest$com_falsepattern_lib_internal_impl_toast_GuiToastImpl$get$mc().func_147118_V());
            }
            if (this.visibility == IToast.Visibility.SHOW && sysTime - this.animationTime <= 600L) {
                this.visibleTime = sysTime;
            }
            GL11.glPushMatrix();
            float shift = (float)this.toast.width() * this.getVisibility(sysTime);
            float X = ToastConfig.leftAlign() ? shift - (float)this.toast.width() : (float)x - shift;
            GL11.glTranslatef((float)X, (float)((float)(y * 32) + (float)ToastConfig.Y_OFFSET), (float)(500 + y));
            IToast.Visibility visibility = this.toast.draw(this.this$0, sysTime - this.visibleTime);
            GL11.glPopMatrix();
            if (visibility != this.visibility) {
                this.animationTime = sysTime - (long)((int)((1.0f - this.getVisibility(sysTime)) * 600.0f));
                this.visibility = visibility;
                this.visibility.playSound(this.this$0.jvmdowngrader$nest$com_falsepattern_lib_internal_impl_toast_GuiToastImpl$get$mc().func_147118_V());
            }
            return this.visibility == IToast.Visibility.HIDE && sysTime - this.animationTime > 600L;
        }
    }
}

