/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mapping;

import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.asm.CoreLoadingPlugin;
import com.falsepattern.lib.mapping.storage.Lookup;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalClass;
import com.falsepattern.lib.mapping.types.UniversalField;
import com.falsepattern.lib.mapping.types.UniversalMethod;
import com.falsepattern.lib.util.ResourceUtil;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class, CleanupThread.class})
public class MappingManager {
    private static Lookup<UniversalClass> internalLookup;
    private static Lookup<UniversalClass> regularLookup;
    private static boolean initialized;
    private static final Object MUTEX;
    private static final AtomicLong lastInitializedAt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Object object = MUTEX;
        synchronized (object) {
            if (initialized) {
                lastInitializedAt.set(System.currentTimeMillis());
                return;
            }
            initialized = true;
            CleanupThread cleanupThread = new CleanupThread();
            FPLog.LOG.info("Initializing MappingManager");
            internalLookup = new Lookup();
            regularLookup = new Lookup();
            HashMap<String, String> stringPool = new HashMap<String, String>();
            String[] classMappings = new String(ResourceUtil.getResourceBytesFromJar("/classes.csv", CoreLoadingPlugin.class)).split("\n");
            for (int i = 1; i < classMappings.length; ++i) {
                String[] line = classMappings[i].split(",");
                UniversalClass clazz = new UniversalClass(line, stringPool);
                internalLookup.unwrap(clazz.internalName, clazz);
                regularLookup.unwrap(clazz.regularName, clazz);
            }
            String[] fieldMappings = new String(ResourceUtil.getResourceBytesFromJar("/fields.csv", CoreLoadingPlugin.class)).split("\n");
            for (int i = 1; i < fieldMappings.length; ++i) {
                String[] line = fieldMappings[i].split(",");
                UniversalClass clazz = internalLookup.get(MappingType.Notch, line[0].substring(0, line[0].lastIndexOf(47)));
                UniversalField.createAndAddToParent(clazz, line, stringPool);
            }
            String[] methodMappings = new String(ResourceUtil.getResourceBytesFromJar("/methods.csv", CoreLoadingPlugin.class)).split("\n");
            for (int i = 1; i < methodMappings.length; ++i) {
                String[] line = methodMappings[i].split(",");
                UniversalClass clazz = internalLookup.get(MappingType.Notch, line[0].substring(0, line[0].lastIndexOf(47)));
                UniversalMethod.createAndAddToParent(clazz, line, stringPool);
            }
            lastInitializedAt.set(System.currentTimeMillis());
            cleanupThread.start();
        }
    }

    public static UniversalClass classForName(NameType nameType, MappingType mappingType, String className) throws ClassNotFoundException {
        MappingManager.initialize();
        try {
            switch (nameType) {
                case Internal: {
                    return internalLookup.get(mappingType, className);
                }
                case Regular: {
                    return regularLookup.get(mappingType, className);
                }
            }
            throw new IllegalArgumentException(MappingManager.jvmdowngrader$concat$classForName$1(String.valueOf((Object)nameType)));
        }
        catch (Lookup.LookupException e) {
            throw new ClassNotFoundException(MappingManager.jvmdowngrader$concat$classForName$1(className, nameType.name().toLowerCase(), mappingType.name()));
        }
    }

    public static boolean containsClass(NameType nameType, MappingType mappingType, String className) {
        MappingManager.initialize();
        switch (nameType) {
            case Internal: {
                return internalLookup.containsKey(mappingType, className);
            }
            case Regular: {
                return regularLookup.containsKey(mappingType, className);
            }
        }
        throw new IllegalArgumentException(MappingManager.jvmdowngrader$concat$classForName$1(String.valueOf((Object)nameType)));
    }

    public static UniversalField getField(FieldInsnNode instruction) throws ClassNotFoundException, NoSuchFieldException {
        MappingManager.initialize();
        if (!CoreLoadingPlugin.isObfuscated()) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.MCP, instruction.owner).getField(MappingType.MCP, instruction.name);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException(MappingManager.jvmdowngrader$concat$getField$1(instruction.owner));
            }
        }
        try {
            return MappingManager.classForName(NameType.Internal, MappingType.SRG, instruction.owner).getField(MappingType.SRG, instruction.name);
        }
        catch (ClassNotFoundException e) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.Notch, instruction.owner).getField(MappingType.Notch, instruction.name);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException(MappingManager.jvmdowngrader$concat$getField$2(instruction.owner));
            }
        }
    }

    public static UniversalMethod getMethod(MethodInsnNode instruction) throws ClassNotFoundException, NoSuchMethodException {
        MappingManager.initialize();
        if (!CoreLoadingPlugin.isObfuscated()) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.MCP, instruction.owner).getMethod(MappingType.MCP, instruction.name, instruction.desc);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException(MappingManager.jvmdowngrader$concat$getField$1(instruction.owner));
            }
        }
        try {
            return MappingManager.classForName(NameType.Internal, MappingType.SRG, instruction.owner).getMethod(MappingType.SRG, instruction.name, instruction.desc);
        }
        catch (ClassNotFoundException e) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.Notch, instruction.owner).getMethod(MappingType.Notch, instruction.name, instruction.desc);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException(MappingManager.jvmdowngrader$concat$getField$2(instruction.owner));
            }
        }
    }

    static {
        initialized = false;
        MUTEX = new Object();
        lastInitializedAt = new AtomicLong();
    }

    public static /* synthetic */ boolean jvmdowngrader$nest$com_falsepattern_lib_mapping_MappingManager$get$initialized() {
        return initialized;
    }

    public static /* synthetic */ Lookup jvmdowngrader$nest$com_falsepattern_lib_mapping_MappingManager$get$internalLookup() {
        return internalLookup;
    }

    public static /* synthetic */ void jvmdowngrader$nest$com_falsepattern_lib_mapping_MappingManager$set$MUTEX(Object object) {
        MUTEX = object;
    }

    public static /* synthetic */ void jvmdowngrader$nest$com_falsepattern_lib_mapping_MappingManager$set$lastInitializedAt(AtomicLong atomicLong) {
        lastInitializedAt = atomicLong;
    }

    public static /* synthetic */ Lookup jvmdowngrader$nest$com_falsepattern_lib_mapping_MappingManager$get$regularLookup() {
        return regularLookup;
    }

    private static /* synthetic */ String jvmdowngrader$concat$classForName$1(String string) {
        return "Invalid enum value " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$classForName$1(String string, String string2, String string3) {
        return "Could not find class \"" + string + "\" with " + string2 + " name in the " + string3 + " mapping.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getField$1(String string) {
        return "Could not find the class " + string + " in the MCP mappings. Are you sure it's a Minecraft class? (we're in dev, cannot use SRG or Notch here).";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getField$2(String string) {
        return "Could not find the class " + string + " neither in the SRG nor in the Notch mappings. Are you sure it's a Minecraft class? (we're in obf, cannot use MCP here)";
    }

    @NestHost(value=MappingManager.class)
    private static class CleanupThread
    extends Thread {
        public CleanupThread() {
            this.setName("MappingManager Cleanup Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Object object = MUTEX;
                synchronized (object) {
                    long time = System.currentTimeMillis();
                    long lastInit = lastInitializedAt.get();
                    if (time - lastInit >= 10000L) {
                        FPLog.LOG.info("Terminating MappingManager");
                        internalLookup = null;
                        regularLookup = null;
                        initialized = false;
                        return;
                    }
                }
            }
        }
    }
}

