/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mapping.storage;

import com.falsepattern.lib.mapping.storage.MappedString;
import com.falsepattern.lib.mapping.types.MappingType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class, LookupException.class})
public class Lookup<T> {
    private final Set<T> values = new HashSet<T>();
    private final Map<String, T> notch = new HashMap<String, T>();
    private final Map<String, T> srg = new HashMap<String, T>();
    private final Map<String, T> mcp = new HashMap<String, T>();

    private static <T> void removeFirst(Iterator<Map.Entry<String, T>> iterator, T value) {
        while (iterator.hasNext()) {
            Map.Entry<String, T> entry = iterator.next();
            if (!entry.getValue().equals(value)) continue;
            iterator.remove();
            return;
        }
    }

    public boolean contains(T value) {
        return this.values.contains(value);
    }

    public boolean containsKey(MappingType mappingType, String key) {
        switch (mappingType) {
            case Notch: {
                return this.notch.containsKey(key);
            }
            case SRG: {
                return this.srg.containsKey(key);
            }
            case MCP: {
                return this.mcp.containsKey(key);
            }
        }
        throw new IllegalArgumentException(Lookup.jvmdowngrader$concat$containsKey$1(String.valueOf((Object)mappingType)));
    }

    public void unwrap(@NonNull MappedString mappedString, @NonNull T value) {
        if (mappedString == null) {
            throw new NullPointerException("mappedString is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.contains(value)) {
            this.values.remove(value);
            Lookup.removeFirst(this.notch.entrySet().iterator(), value);
            Lookup.removeFirst(this.srg.entrySet().iterator(), value);
            Lookup.removeFirst(this.mcp.entrySet().iterator(), value);
        }
        this.values.add(value);
        this.notch.put(mappedString.notch, value);
        this.srg.put(mappedString.srg, value);
        this.mcp.put(mappedString.mcp, value);
    }

    public T get(MappingType mappingType, String key) throws LookupException {
        T result;
        switch (mappingType) {
            case Notch: {
                result = this.notch.get(key);
                break;
            }
            case SRG: {
                result = this.srg.get(key);
                break;
            }
            case MCP: {
                result = this.mcp.get(key);
                break;
            }
            default: {
                throw new IllegalArgumentException(Lookup.jvmdowngrader$concat$containsKey$1(String.valueOf((Object)mappingType)));
            }
        }
        if (result == null) {
            throw new LookupException(Lookup.jvmdowngrader$concat$get$1(key, String.valueOf((Object)mappingType)));
        }
        return result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lookup)) {
            return false;
        }
        Lookup other = (Lookup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<T> this$values = this.values;
        Set<T> other$values = other.values;
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        Map<String, T> this$notch = this.notch;
        Map<String, T> other$notch = other.notch;
        if (this$notch == null ? other$notch != null : !((Object)this$notch).equals(other$notch)) {
            return false;
        }
        Map<String, T> this$srg = this.srg;
        Map<String, T> other$srg = other.srg;
        if (this$srg == null ? other$srg != null : !((Object)this$srg).equals(other$srg)) {
            return false;
        }
        Map<String, T> this$mcp = this.mcp;
        Map<String, T> other$mcp = other.mcp;
        return !(this$mcp == null ? other$mcp != null : !((Object)this$mcp).equals(other$mcp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Lookup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<T> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        Map<String, T> $notch = this.notch;
        result = result * 59 + ($notch == null ? 43 : ((Object)$notch).hashCode());
        Map<String, T> $srg = this.srg;
        result = result * 59 + ($srg == null ? 43 : ((Object)$srg).hashCode());
        Map<String, T> $mcp = this.mcp;
        result = result * 59 + ($mcp == null ? 43 : ((Object)$mcp).hashCode());
        return result;
    }

    private static /* synthetic */ String jvmdowngrader$concat$containsKey$1(String string) {
        return "Invalid enum value " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$get$1(String string, String string2) {
        return "No such key " + string + " in " + string2;
    }

    @NestHost(value=Lookup.class)
    public static class LookupException
    extends Exception {
        @ApiStatus.Internal
        public LookupException(String message) {
            super(message);
        }
    }
}

