/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.toasts.icon;

import com.falsepattern.lib.util.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public abstract class ToastTexture {
    protected final IIcon icon;
    protected final ResourceLocation texture;

    public ToastTexture(@NonNull ResourceLocation texture, int width, int height) {
        this(texture, RenderUtil.getFullTextureIcon(texture.toString(), width, height));
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
    }

    public ToastTexture(@NonNull ResourceLocation texture, @NonNull IIcon icon) {
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        if (icon == null) {
            throw new NullPointerException("icon is marked non-null but is null");
        }
        this.icon = icon;
        this.texture = texture;
    }

    public abstract void draw(Gui var1, int var2, int var3);

    @Generated
    public IIcon getIcon() {
        return this.icon;
    }

    @Generated
    public ResourceLocation getTexture() {
        return this.texture;
    }
}

