/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraftforge.common.config.Property;

public class IntConfigField
extends AConfigField<Integer> {
    private final boolean primitive;
    private final int defaultValue;
    private final int min;
    private final int max;

    public IntConfigField(ConfigFieldParameters params) {
        super(params, Property.Type.INTEGER);
        this.primitive = this.field.getType().isPrimitive();
        Optional<Config.RangeInt> range = Optional.ofNullable(this.field.getAnnotation(Config.RangeInt.class));
        this.min = range.map(Config.RangeInt::min).orElse(Integer.MIN_VALUE);
        this.max = range.map(Config.RangeInt::max).orElse(Integer.MAX_VALUE);
        this.defaultValue = Optional.ofNullable(this.field.getAnnotation(Config.DefaultInt.class)).map(Config.DefaultInt::value).orElseThrow(() -> IntConfigField.noDefault(this.field, "DefaultInt"));
        Property property = this.getProperty();
        property.setDefaultValue(this.defaultValue);
        property.setMinValue(this.min);
        property.setMaxValue(this.max);
        if (!property.isIntValue()) {
            this.setToDefault();
        }
        property.comment = IntConfigField.jvmdowngrader$concat$$init$$1(property.comment, this.min, this.max, this.defaultValue);
    }

    @Override
    protected Integer getField() {
        return this.primitive ? this.field.getInt(null) : ((Integer)this.field.get(null)).intValue();
    }

    @Override
    protected void putField(Integer value) {
        if (this.primitive) {
            this.field.setInt(null, value);
        } else {
            this.field.set(null, value);
        }
    }

    @Override
    protected Integer getConfig() {
        return this.getProperty().getInt();
    }

    @Override
    protected void putConfig(Integer value) {
        this.getProperty().set(value.intValue());
    }

    @Override
    protected Integer getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        if (!this.primitive && this.field.get(null) == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        int value = this.getField();
        if (value >= this.min && value <= this.max) {
            return true;
        }
        ConfigValidationFailureEvent.postNumericRangeOutOfBounds(this.field, -1, Integer.toString(value), Integer.toString(this.min), Integer.toString(this.max));
        return false;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        output.writeInt(this.getField());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(input.readInt());
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string, int n, int n2, int n3) {
        return string + "\n[range: " + n + " ~ " + n2 + ", default: " + n3 + "]";
    }
}

