/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mapping.types;

import com.falsepattern.lib.internal.ReflectionUtil;
import com.falsepattern.lib.mapping.storage.MappedString;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalClass;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.objectweb.asm.tree.MethodInsnNode;

public class UniversalMethod {
    public final UniversalClass parent;
    public final MappedString name;
    public final MappedString descriptor;
    public final MappedString fusedNameDescriptor;
    private Method javaMethodCache = null;

    private UniversalMethod(@NonNull UniversalClass parent, String[] names, Map<String, String> stringPool) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.parent = parent;
        this.name = new MappedString(names, 0, 2, str -> str.substring(str.lastIndexOf(47) + 1), stringPool);
        this.descriptor = new MappedString(names, 1, 2, str -> str, stringPool);
        this.fusedNameDescriptor = MappedString.fuse(this.name, this.descriptor, "", stringPool);
        parent.addMethod(this);
    }

    public static void createAndAddToParent(@NonNull UniversalClass parent, String[] names, Map<String, String> stringPool) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        new UniversalMethod(parent, names, stringPool);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Class<?>[] decodeMethodDescriptor(String desc) throws ClassNotFoundException {
        ArrayList<void> result = new ArrayList<void>();
        StringBuilder buf = new StringBuilder();
        boolean readingReference = false;
        int arrayDimensions = 0;
        char[] cArray = desc.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                void var9_9;
                block20: {
                    char c;
                    block18: {
                        block19: {
                            c = cArray[n2];
                            Object var9_10 = null;
                            if (!readingReference) break block18;
                            if (c != ';') break block19;
                            Class<?> clazz = Class.forName(buf.toString().replace('/', '.'));
                            buf.setLength(0);
                            readingReference = false;
                            break block20;
                        }
                        buf.append(c);
                        break block21;
                    }
                    if (c == '(') break block21;
                    if (c == ')') {
                        return result.toArray(new Class[0]);
                    }
                    switch (c) {
                        case 'B': {
                            Class<Byte> clazz = Byte.TYPE;
                            break;
                        }
                        case 'C': {
                            Class<Character> clazz = Character.TYPE;
                            break;
                        }
                        case 'D': {
                            Class<Double> clazz = Double.TYPE;
                            break;
                        }
                        case 'F': {
                            Class<Float> clazz = Float.TYPE;
                            break;
                        }
                        case 'I': {
                            Class<Integer> clazz = Integer.TYPE;
                            break;
                        }
                        case 'J': {
                            Class<Long> clazz = Long.TYPE;
                            break;
                        }
                        case 'L': {
                            readingReference = true;
                            break block21;
                        }
                        case 'S': {
                            Class<Short> clazz = Short.TYPE;
                            break;
                        }
                        case 'Z': {
                            Class<Boolean> clazz = Boolean.TYPE;
                            break;
                        }
                        case '[': {
                            ++arrayDimensions;
                            break block21;
                        }
                    }
                }
                for (int i = 0; i < arrayDimensions; ++i) {
                    Class<?> clazz = Array.newInstance(var9_9, 0).getClass();
                }
                arrayDimensions = 0;
                result.add(var9_9);
            }
            ++n2;
        }
        return result.toArray(new Class[0]);
    }

    public String getName(MappingType mappingType) {
        return this.name.get(mappingType);
    }

    public String getDescriptor(MappingType mappingType) {
        return this.descriptor.get(mappingType);
    }

    public Method asJavaMethod() throws ClassNotFoundException, NoSuchMethodException {
        if (this.javaMethodCache != null) {
            return this.javaMethodCache;
        }
        Class<?> parentClass = this.parent.asJavaClass();
        this.javaMethodCache = parentClass.getDeclaredMethod(this.getName(this.parent.realClassMapping()), UniversalMethod.decodeMethodDescriptor(this.getDescriptor(this.parent.realClassMapping())));
        ReflectionUtil.jailBreak(this.javaMethodCache);
        return this.javaMethodCache;
    }

    public <T> T invoke(Object instance, Object ... arguments) {
        Method m = this.asJavaMethod();
        return (T)m.invoke(instance, arguments);
    }

    public <T> T invokeStatic(Object ... arguments) {
        return this.invoke(null, arguments);
    }

    public MethodInsnNode asInstruction(int opcode, MappingType mapping, boolean itf) {
        return new MethodInsnNode(opcode, this.parent.getName(NameType.Internal, mapping), this.getName(mapping), this.getDescriptor(mapping), itf);
    }

    @Generated
    public String toString() {
        return UniversalMethod.jvmdowngrader$concat$toString$1(String.valueOf(this.name()), String.valueOf(this.descriptor()), String.valueOf(this.fusedNameDescriptor()), String.valueOf(this.javaMethodCache));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniversalMethod)) {
            return false;
        }
        UniversalMethod other = (UniversalMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MappedString this$name = this.name();
        MappedString other$name = other.name();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        MappedString this$descriptor = this.descriptor();
        MappedString other$descriptor = other.descriptor();
        if (this$descriptor == null ? other$descriptor != null : !((Object)this$descriptor).equals(other$descriptor)) {
            return false;
        }
        MappedString this$fusedNameDescriptor = this.fusedNameDescriptor();
        MappedString other$fusedNameDescriptor = other.fusedNameDescriptor();
        if (this$fusedNameDescriptor == null ? other$fusedNameDescriptor != null : !((Object)this$fusedNameDescriptor).equals(other$fusedNameDescriptor)) {
            return false;
        }
        Method this$javaMethodCache = this.javaMethodCache;
        Method other$javaMethodCache = other.javaMethodCache;
        return !(this$javaMethodCache == null ? other$javaMethodCache != null : !((Object)this$javaMethodCache).equals(other$javaMethodCache));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UniversalMethod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MappedString $name = this.name();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        MappedString $descriptor = this.descriptor();
        result = result * 59 + ($descriptor == null ? 43 : ((Object)$descriptor).hashCode());
        MappedString $fusedNameDescriptor = this.fusedNameDescriptor();
        result = result * 59 + ($fusedNameDescriptor == null ? 43 : ((Object)$fusedNameDescriptor).hashCode());
        Method $javaMethodCache = this.javaMethodCache;
        result = result * 59 + ($javaMethodCache == null ? 43 : ((Object)$javaMethodCache).hashCode());
        return result;
    }

    @Generated
    public UniversalClass parent() {
        return this.parent;
    }

    @Generated
    public MappedString name() {
        return this.name;
    }

    @Generated
    public MappedString descriptor() {
        return this.descriptor;
    }

    @Generated
    public MappedString fusedNameDescriptor() {
        return this.fusedNameDescriptor;
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3, String string4) {
        return "UniversalMethod(name=" + string + ", descriptor=" + string2 + ", fusedNameDescriptor=" + string3 + ", javaMethodCache=" + string4 + ")";
    }
}

