/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.google.common.io.Files;
import java.nio.file.Path;
import java.util.function.Predicate;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={PredicateHelpers.class})
public interface ITargetedMod {
    public String getModName();

    public boolean isLoadInDevelopment();

    default public boolean isMatchingJar(Path path) {
        String pathString = path.toString();
        String nameLowerCase = Files.getNameWithoutExtension((String)pathString).toLowerCase();
        String fileExtension = Files.getFileExtension((String)pathString);
        return "jar".equals(fileExtension) && this.getCondition().test(nameLowerCase);
    }

    public Predicate<String> getCondition();

    @NestHost(value=ITargetedMod.class)
    public static final class PredicateHelpers {
        public static Predicate<String> startsWith(String subString) {
            return name -> name.startsWith(subString.toLowerCase());
        }

        public static Predicate<String> contains(String subString) {
            return name -> name.contains(subString.toLowerCase());
        }

        public static Predicate<String> matches(String regex) {
            return name -> name.matches(regex);
        }
    }
}

