/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.util;

import com.falsepattern.lib.internal.FPLog;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

public final class ResourceUtil {
    public static String getResourceStringFromJar(String resourcePath, Class<?> referenceClass) throws IOException {
        return ResourceUtil.getResourceStringFromJar(resourcePath, referenceClass, StandardCharsets.UTF_8);
    }

    public static String getResourceStringFromJar(String resourcePath, Class<?> referenceClass, Charset charset) throws IOException {
        return new String(ResourceUtil.getResourceBytesFromJar(resourcePath, referenceClass), charset);
    }

    public static byte[] getResourceBytesFromJar(String resourcePath, Class<?> referenceClass) throws IOException {
        return ResourceUtil.readBytesSafe(ResourceUtil.getResourceFromJar(resourcePath, referenceClass), resourcePath);
    }

    private static byte[] readBytesSafe(InputStream stream, String resourcePath) throws IOException {
        if (stream == null) {
            throw new FileNotFoundException(ResourceUtil.jvmdowngrader$concat$readBytesSafe$1(resourcePath));
        }
        return ResourceUtil.readBytes(stream);
    }

    public static InputStream getResourceFromJar(String resourcePath, Class<?> referenceClass) {
        URL classFile = referenceClass.getResource(ResourceUtil.jvmdowngrader$concat$getResourceFromJar$1(referenceClass.getName().replace('.', '/')));
        if (classFile != null) {
            String file = classFile.getFile();
            int id = file.indexOf("!");
            if (classFile.getProtocol().equals("jar") && id >= 0) {
                try {
                    URL resource = new URL(ResourceUtil.jvmdowngrader$concat$getResourceFromJar$1(file.substring(0, id), resourcePath));
                    return resource.openStream();
                }
                catch (IOException e) {
                    FPLog.LOG.error(ResourceUtil.jvmdowngrader$concat$getResourceFromJar$2(resourcePath, file.substring(0, id)), (Throwable)e);
                }
            }
        }
        FPLog.LOG.warn(ResourceUtil.jvmdowngrader$concat$getResourceFromJar$3(resourcePath, referenceClass.getName()));
        return referenceClass.getResourceAsStream(resourcePath);
    }

    public static byte[] readBytes(InputStream stream) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((read = stream.read(buf)) >= 0) {
            out.write(buf, 0, read);
        }
        return out.toByteArray();
    }

    public static String getResourceString(String resourcePath) throws IOException {
        return ResourceUtil.getResourceString(resourcePath, StandardCharsets.UTF_8);
    }

    public static String getResourceString(String resourcePath, Charset charset) throws IOException {
        return new String(ResourceUtil.getResourceBytes(resourcePath), charset);
    }

    public static byte[] getResourceBytes(String resourcePath) throws IOException {
        return ResourceUtil.readBytesSafe(ResourceUtil.class.getResourceAsStream(resourcePath), resourcePath);
    }

    @Generated
    private ResourceUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ String jvmdowngrader$concat$readBytesSafe$1(String string) {
        return "Could not find resource at " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getResourceFromJar$1(String string) {
        return "/" + string + ".class";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getResourceFromJar$1(String string, String string2) {
        return "jar:" + string + "!" + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getResourceFromJar$2(String string, String string2) {
        return "Failed to load resource " + string + " from jar " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getResourceFromJar$3(String string, String string2) {
        return "Using fallback resource loading logic for " + string + " with reference to " + string2;
    }
}

