FalsePatternLib JSON dependency file example
Version 2

An example JSON file that can be used to download dependencies using FalsePatternLib. This replaces the legacy
DependencyLoader api. This file needs to reside inside the META-INF directory.

```json
{
  "identifier": "falsepatternlib_dependencies",
  "minJava": 8,
  "maxJava": 8,
  "bundledArtifacts": [
    "com.example:myjar:1.2.3"
  ],
  "repositories": [
    "https://example.com/"
  ],
  "dependencies": {
    "always": {
      "common": [],
      "client": [],
      "server": []
    },
    "obf": {
      "common": [
        "com.example:examplejar:1.0.0"
      ],
      "client": [],
      "server": []
    },
    "dev": {
      "common": [],
      "client": [],
      "server": []
    }
  },
  "modDependencies": {
    "always": {
      "common": [
        "com.example:mymod:3.0.0",
        {
          "modid": "mylib",
          "artifact": "com.example:mylib:1.0.2"
        }
      ],
      "client": [],
      "server": []
    },
    "obf": {
      "common": [],
      "client": [],
      "server": []
    },
    "dev": {
      "common": [],
      "client": [],
      "server": []
    }
  }
}
```

Explanation:

- `identifier`: The identifier of the json file. This must always be `falsepatternlib_dependencies` for the library
  downloader
  to recognize it.
- `minJava`: The lowest java major version to load dependencies from this file for (inclusive). Can be omitted, in which case
  it will load dependencies for any java versions below or equal maxJava.
- `maxJava`: The highest java major version to load dependencies from this file for (inclusive). If omitted, it will load dependencies
  for any java versions above or equal minJava.
- If both `minJava` and `maxJava` are unset, dependencies from the file will be loaded regardless of java version.
- If you want to load dependencies for multiple different java ranges, use multiple dependency jsons.
- `bundledArtifacts`: A list of maven artifacts which are "shaded" into this jar without relocation. Useful for recursive deploading of mc mods.
- `repositories`: A list of maven repositories to use when downloading dependencies. These are used in addition to the
  default maven repositories. This is just a list of strings, each string being a https repository url.
  Additionally, every jar with a dependencies json file inside of it is treated as a "jar in jar" maven repository.
  This maven repository exists under `META-INF/falsepatternlib_repo/`
- `dependencies`: A categorized list of dependencies.
    - The `always` category gets downloaded both inside and outside the dev environment. Usually not needed, as gradle
      will automatically download dependencies.
    - The `obf` category gets downloaded only in the obfuscated environment. Any third party libraries that are not
      available by default from minecraft or forge, AND are also not shaded/shadowed into the jar, should be placed
      here.
    - The `dev` category gets downloaded only in the dev environment. Usually not needed, as gradle will automatically
      download dependencies.
- `modDependencies`: Same as `dependencies`, but files from here get downloaded into `.minecraft/mods/1.7.10`. Useful
  if you want to download third party mods as well. Additionally, instead of a single maven artifact string, you can use
  a json object with separate `modid` and `artifact` attributes, which can be used to filter against a specific mod ID in
  addition to plain artifact matching against other downloaded libraries and `bundledArtifacts`. This is useful if you
  want to depload a mod that doesn't have a marker json in it.

Each of these categories also have 3 more subcategories:

- `common`: Dependencies that are required on both the client and the server.
- `client`: Dependencies that are required on the client only.
- `server`: Dependencies that are required on the server only.

Each of these subcategories is a list of strings, each string being a maven dependency string. These are the same as
the ones used in the gradle dependencies block. Note that this DOES NOT support the version range syntax, so you must
specify a specific version. For example, `com.example:examplejar:1.0.0` is valid,
but `com.example:examplejar:[1.0.0,2.0.0]` is not.
