/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "dream_enchantment.json");
    public boolean enableVoidAssault = true;
    public boolean enableChase = true;
    public boolean enableSoulSiphon = true;
    public boolean enableAmbush = true;
    public boolean enableSoulConduit = true;
    public boolean enablePoison = true;
    public boolean enableVigor = true;
    public boolean enableSoulResonance = true;
    public boolean enableExplosion = true;
    public boolean enablePainCycle = true;
    public boolean enableProspector = true;
    public boolean enableFriendly = true;
    public boolean enableSoulSynergy = true;
    public boolean enableFrostbite = true;
    public boolean enableStun = true;
    public boolean enableIllagerBane = true;
    public boolean enableCounterStrike = true;
    public boolean enableExecute = true;
    public boolean enableGuardianStrike = true;
    public boolean enableCustomPoisonEffect = true;
    public boolean enableFrostbiteEffect = true;
    public boolean enableStunEffect = true;

    public static ModConfig load() {
        ModConfig config = new ModConfig();
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config file, using defaults: " + e.getMessage());
            }
        }
        config.save();
        return config;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save config file: " + e.getMessage());
        }
    }
}

