/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.mixin;

import com.bmt.de.DreamEnchantment;
import com.bmt.de.enchantment.AmbushEnchantment;
import com.bmt.de.enchantment.ExecuteEnchantment;
import com.bmt.de.enchantment.SoulConduitEnchantment;
import com.bmt.de.enchantment.SoulResonanceEnchantment;
import com.bmt.de.enchantment.SoulSynergyEnchantment;
import com.bmt.de.enchantment.VigorEnchantment;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1433;
import net.minecraft.class_1439;
import net.minecraft.class_1477;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5354;
import net.minecraft.class_5776;
import net.minecraft.class_5819;
import net.minecraft.class_7298;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Unique
    private static final String PAIN_CYCLE_COUNT_KEY = "PainCycleCount";
    @Unique
    private static final String PAIN_CYCLE_LEVEL_KEY = "PainCycleLevel";

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    private float modifyDamage(float amount, class_1282 source) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (amount > 0.0f) {
                int executeLevel;
                class_2487 nbt;
                int soulResonanceLevel;
                int vigorStacks;
                class_2487 nbt2;
                int vigorLevel;
                int ambushLevel;
                class_5819 random;
                int voidAssaultLevel;
                class_1309 target;
                int friendlyLevel;
                if (player.method_37908().method_8608()) {
                    return amount;
                }
                if (DreamEnchantment.FRIENDLY != null && (friendlyLevel = class_1890.method_8225((class_1887)DreamEnchantment.FRIENDLY, (class_1799)player.method_6047())) > 0 && this.isFriendlyMob(target = (class_1309)this)) {
                    return 0.0f;
                }
                if (DreamEnchantment.VOID_ASSAULT != null && (voidAssaultLevel = class_1890.method_8225((class_1887)DreamEnchantment.VOID_ASSAULT, (class_1799)player.method_6047())) > 0 && (random = player.method_6051()).method_43057() < 0.15f) {
                    float damageMultiplier = this.getVoidAssaultMultiplier(voidAssaultLevel);
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                    amount *= damageMultiplier;
                }
                if (DreamEnchantment.AMBUSH != null && (ambushLevel = class_1890.method_8225((class_1887)DreamEnchantment.AMBUSH, (class_1799)player.method_6047())) > 0 && AmbushEnchantment.isPlayerSneaking(player)) {
                    float ambushMultiplier = AmbushEnchantment.getSneakDamageMultiplier(ambushLevel);
                    amount *= ambushMultiplier;
                }
                if (DreamEnchantment.VIGOR != null && (vigorLevel = class_1890.method_8225((class_1887)DreamEnchantment.VIGOR, (class_1799)player.method_6047())) > 0 && player.method_6047().method_7985() && (nbt2 = player.method_6047().method_7969()).method_10545("VigorStacks") && (vigorStacks = nbt2.method_10550("VigorStacks")) > 0) {
                    float vigorMultiplier = VigorEnchantment.getDamageMultiplier(vigorStacks, vigorLevel);
                    amount *= 1.0f + vigorMultiplier;
                }
                if (DreamEnchantment.SOUL_RESONANCE != null && (soulResonanceLevel = class_1890.method_8225((class_1887)DreamEnchantment.SOUL_RESONANCE, (class_1799)player.method_6047())) > 0) {
                    int playerExperienceLevel = player.field_7520;
                    float soulResonanceMultiplier = SoulResonanceEnchantment.getDamageMultiplier(playerExperienceLevel, soulResonanceLevel);
                    amount *= 1.0f + soulResonanceMultiplier;
                }
                if (DreamEnchantment.PAIN_CYCLE != null && player.method_6047().method_7985() && (nbt = player.method_6047().method_7969()).method_10545(PAIN_CYCLE_COUNT_KEY) && nbt.method_10545(PAIN_CYCLE_LEVEL_KEY)) {
                    int painCycleCount = nbt.method_10550(PAIN_CYCLE_COUNT_KEY);
                    int painCycleLevel = nbt.method_10550(PAIN_CYCLE_LEVEL_KEY);
                    if (painCycleCount >= 5) {
                        float painCycleMultiplier = painCycleLevel + 1;
                        amount *= painCycleMultiplier;
                        nbt.method_10551(PAIN_CYCLE_COUNT_KEY);
                        nbt.method_10551(PAIN_CYCLE_LEVEL_KEY);
                    }
                }
                if (DreamEnchantment.EXECUTE != null && (executeLevel = class_1890.method_8225((class_1887)DreamEnchantment.EXECUTE, (class_1799)player.method_6047())) > 0) {
                    class_1309 target2 = (class_1309)this;
                    float executeMultiplier = ExecuteEnchantment.getExecuteDamageMultiplier(target2, executeLevel);
                    amount *= executeMultiplier;
                }
            }
        }
        return amount;
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void onDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (amount > 0.0f) {
                int painCycleLevel;
                int soulConduitLevel;
                int soulSynergyLevel;
                if (player.method_37908().method_8608()) {
                    return;
                }
                if (DreamEnchantment.SOUL_SYNERGY != null && (soulSynergyLevel = class_1890.method_8225((class_1887)DreamEnchantment.SOUL_SYNERGY, (class_1799)player.method_6047())) > 0) {
                    class_1309 target = (class_1309)this;
                    this.applySoulSynergyDamage(player, target, amount, (class_3218)player.method_37908());
                }
                if (DreamEnchantment.SOUL_CONDUIT != null && (soulConduitLevel = class_1890.method_8225((class_1887)DreamEnchantment.SOUL_CONDUIT, (class_1799)player.method_6047())) > 0) {
                    this.applySoulConduitHealing(player, amount, soulConduitLevel);
                }
                if (DreamEnchantment.PAIN_CYCLE != null && (painCycleLevel = class_1890.method_8225((class_1887)DreamEnchantment.PAIN_CYCLE, (class_1799)player.method_6047())) > 0) {
                    this.applyPainCycleCount(player, painCycleLevel);
                }
            }
        }
    }

    @Unique
    private void applySoulSynergyDamage(class_1657 player, class_1309 target, float originalDamage, class_3218 world) {
        SoulSynergyEnchantment.clearExpiredMarks(player);
        List<class_1309> markedEntities = SoulSynergyEnchantment.getMarkedEntities(player, world);
        if (markedEntities.size() > 1 && markedEntities.contains(target)) {
            float sharedDamage = originalDamage / (float)markedEntities.size();
            for (class_1309 entity : markedEntities) {
                if (entity == target || !entity.method_5805()) continue;
                entity.method_5643(world.method_48963().method_48831(), sharedDamage);
            }
        }
    }

    @Unique
    private void applySoulConduitHealing(class_1657 player, float damageDealt, int level) {
        float healingPercentage = SoulConduitEnchantment.getHealingPercentage(level);
        float healingAmount = damageDealt * healingPercentage;
        if (healingAmount > 0.0f) {
            player.method_6025(healingAmount);
        }
    }

    @Unique
    private void applyPainCycleCount(class_1657 player, int level) {
        class_2487 nbt = player.method_6047().method_7948();
        int currentCount = nbt.method_10550(PAIN_CYCLE_COUNT_KEY);
        nbt.method_10569(PAIN_CYCLE_COUNT_KEY, ++currentCount);
        nbt.method_10569(PAIN_CYCLE_LEVEL_KEY, level);
        player.method_5643(player.method_48923().method_48831(), 1.0f);
    }

    @Unique
    private float getVoidAssaultMultiplier(int level) {
        switch (level) {
            case 1: {
                return 1.4f;
            }
            case 2: {
                return 1.8f;
            }
            case 3: {
                return 2.4f;
            }
        }
        return 1.0f;
    }

    @Unique
    private boolean isFriendlyMob(class_1309 entity) {
        class_5354 angerable;
        if (entity instanceof class_1296) {
            return true;
        }
        if (entity instanceof class_5354 && !(angerable = (class_5354)entity).method_29511()) {
            return true;
        }
        return entity instanceof class_1439 || entity instanceof class_7298 || entity instanceof class_1420 || entity instanceof class_1477 || entity instanceof class_5776 || entity instanceof class_1433;
    }
}

