/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.mixin;

import com.bmt.de.DreamEnchantment;
import com.bmt.de.enchantment.SoulConduitEnchantment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin {
    @Unique
    private static final String VOID_ASSAULT_KEY = "VoidAssaultLevel";
    @Unique
    private static final String VOID_ASSAULT_TRIGGERED = "VoidAssaultTriggered";
    @Unique
    private static final String VIGOR_STACKS_KEY = "VigorStacks";
    @Unique
    private static final String PAIN_CYCLE_COUNT_KEY = "PainCycleCount";
    @Unique
    private static final String PAIN_CYCLE_LEVEL_KEY = "PainCycleLevel";

    @Inject(method={"jump"}, at={@At(value="HEAD")})
    private void onJump(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (player.method_37908().method_8608()) {
            return;
        }
        int vigorLevel = class_1890.method_8225((class_1887)DreamEnchantment.VIGOR, (class_1799)player.method_6047());
        if (vigorLevel > 0) {
            class_2487 nbt = player.method_6047().method_7948();
            int currentStacks = nbt.method_10550(VIGOR_STACKS_KEY);
            int newStacks = Math.min(currentStacks + 1, 20);
            nbt.method_10569(VIGOR_STACKS_KEY, newStacks);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void onAttackStart(class_1297 target, CallbackInfo ci) {
        int painCycleLevel;
        class_1657 player = (class_1657)this;
        if (player.method_37908().method_8608() || !(target instanceof class_1309)) {
            return;
        }
        int voidAssaultLevel = class_1890.method_8225((class_1887)DreamEnchantment.VOID_ASSAULT, (class_1799)player.method_6047());
        if (voidAssaultLevel > 0 && player.method_6051().method_43057() < 0.15f) {
            class_2487 nbt = player.method_6047().method_7948();
            nbt.method_10569(VOID_ASSAULT_KEY, voidAssaultLevel);
            nbt.method_10556(VOID_ASSAULT_TRIGGERED, true);
        }
        if ((painCycleLevel = class_1890.method_8225((class_1887)DreamEnchantment.PAIN_CYCLE, (class_1799)player.method_6047())) > 0) {
            class_2487 nbt = player.method_6047().method_7948();
            int currentCount = nbt.method_10550(PAIN_CYCLE_COUNT_KEY);
            int newCount = currentCount + 1;
            nbt.method_10569(PAIN_CYCLE_COUNT_KEY, newCount);
            nbt.method_10569(PAIN_CYCLE_LEVEL_KEY, painCycleLevel);
            float healthToLose = player.method_6063() * 0.1f;
            player.method_5643(player.method_48923().method_48831(), healthToLose);
        }
    }

    @Inject(method={"attack"}, at={@At(value="TAIL")})
    private void onAttackEnd(class_1297 target, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (player.method_6047().method_7985()) {
            class_2487 nbt = player.method_6047().method_7969();
            nbt.method_10551(VOID_ASSAULT_KEY);
            nbt.method_10551(VOID_ASSAULT_TRIGGERED);
            nbt.method_10551(VIGOR_STACKS_KEY);
        }
    }

    @Inject(method={"addExperience"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddExperience(int experience, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (player.method_37908().method_8608()) {
            return;
        }
        int soulConduitLevel = class_1890.method_8225((class_1887)DreamEnchantment.SOUL_CONDUIT, (class_1799)player.method_6047());
        if (soulConduitLevel > 0 && experience > 0) {
            float maxHealth;
            float healingPercentage = SoulConduitEnchantment.getHealingPercentage(soulConduitLevel);
            int healingAmount = Math.round((float)experience * healingPercentage);
            int remainingExperience = experience - healingAmount;
            float currentHealth = player.method_6032();
            if (currentHealth < (maxHealth = player.method_6063())) {
                float healthToHeal = Math.min((float)healingAmount, maxHealth - currentHealth);
                player.method_6025(healthToHeal);
                int actualHealing = Math.round(healthToHeal);
                int leftoverExperience = healingAmount - actualHealing;
                if (leftoverExperience > 0) {
                    player.method_7255(leftoverExperience + remainingExperience);
                } else {
                    player.method_7255(remainingExperience);
                }
            } else {
                player.method_7255(experience);
            }
            ci.cancel();
        }
    }
}

