/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de;

import com.bmt.de.enchantment.AmbushEnchantment;
import com.bmt.de.enchantment.BonusShotEnchantment;
import com.bmt.de.enchantment.BusyBeeEnchantment;
import com.bmt.de.enchantment.ChargeEnchantment;
import com.bmt.de.enchantment.ChaseEnchantment;
import com.bmt.de.enchantment.ExecuteEnchantment;
import com.bmt.de.enchantment.ExplosionEnchantment;
import com.bmt.de.enchantment.FriendlyEnchantment;
import com.bmt.de.enchantment.FrostbiteEnchantment;
import com.bmt.de.enchantment.GuardianStrikeEnchantment;
import com.bmt.de.enchantment.IllagerBaneEnchantment;
import com.bmt.de.enchantment.PainCycleEnchantment;
import com.bmt.de.enchantment.PoisonEnchantment;
import com.bmt.de.enchantment.ProspectorEnchantment;
import com.bmt.de.enchantment.SoulConduitEnchantment;
import com.bmt.de.enchantment.SoulResonanceEnchantment;
import com.bmt.de.enchantment.SoulSiphonEnchantment;
import com.bmt.de.enchantment.SoulSynergyEnchantment;
import com.bmt.de.enchantment.StunEnchantment;
import com.bmt.de.enchantment.VigorEnchantment;
import com.bmt.de.enchantment.VoidAssaultEnchantment;
import com.bmt.de.enchantment.VoidEchoEnchantment;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EnchantmentRegistry {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"dream_enchantment");
    public static final RegistryObject<Enchantment> VOID_ASSAULT = ENCHANTMENTS.register("void_assault", VoidAssaultEnchantment::new);
    public static final RegistryObject<Enchantment> CHASE = ENCHANTMENTS.register("chase", ChaseEnchantment::new);
    public static final RegistryObject<Enchantment> SOUL_SIPHON = ENCHANTMENTS.register("soul_siphon", SoulSiphonEnchantment::new);
    public static final RegistryObject<Enchantment> AMBUSH = ENCHANTMENTS.register("ambush", AmbushEnchantment::new);
    public static final RegistryObject<Enchantment> SOUL_CONDUIT = ENCHANTMENTS.register("soul_conduit", SoulConduitEnchantment::new);
    public static final RegistryObject<Enchantment> POISON = ENCHANTMENTS.register("poison", PoisonEnchantment::new);
    public static final RegistryObject<Enchantment> VIGOR = ENCHANTMENTS.register("vigor", VigorEnchantment::new);
    public static final RegistryObject<Enchantment> SOUL_RESONANCE = ENCHANTMENTS.register("soul_resonance", SoulResonanceEnchantment::new);
    public static final RegistryObject<Enchantment> EXPLOSION = ENCHANTMENTS.register("explosion", ExplosionEnchantment::new);
    public static final RegistryObject<Enchantment> PAIN_CYCLE = ENCHANTMENTS.register("pain_cycle", PainCycleEnchantment::new);
    public static final RegistryObject<Enchantment> PROSPECTOR = ENCHANTMENTS.register("prospector", ProspectorEnchantment::new);
    public static final RegistryObject<Enchantment> FRIENDLY = ENCHANTMENTS.register("friendly", FriendlyEnchantment::new);
    public static final RegistryObject<Enchantment> SOUL_SYNERGY = ENCHANTMENTS.register("soul_synergy", SoulSynergyEnchantment::new);
    public static final RegistryObject<Enchantment> FROSTBITE = ENCHANTMENTS.register("frostbite", FrostbiteEnchantment::new);
    public static final RegistryObject<Enchantment> STUN = ENCHANTMENTS.register("stun", StunEnchantment::new);
    public static final RegistryObject<Enchantment> ILLAGER_BANE = ENCHANTMENTS.register("illager_bane", IllagerBaneEnchantment::new);
    public static final RegistryObject<Enchantment> VOID_ECHO = ENCHANTMENTS.register("void_echo", VoidEchoEnchantment::new);
    public static final RegistryObject<Enchantment> EXECUTE = ENCHANTMENTS.register("execute", ExecuteEnchantment::new);
    public static final RegistryObject<Enchantment> GUARDIAN_STRIKE = ENCHANTMENTS.register("guardian_strike", GuardianStrikeEnchantment::new);
    public static final RegistryObject<Enchantment> BUSY_BEE = ENCHANTMENTS.register("busy_bee", BusyBeeEnchantment::new);
    public static final RegistryObject<Enchantment> BONUS_SHOT = ENCHANTMENTS.register("bonus_shot", BonusShotEnchantment::new);
    public static final RegistryObject<Enchantment> CHARGE = ENCHANTMENTS.register("charge", ChargeEnchantment::new);
    public static final Map<String, RegistryObject<Enchantment>> ENCHANTMENT_MAP = new HashMap<String, RegistryObject<Enchantment>>();

    public static void register(IEventBus eventBus) {
        ENCHANTMENTS.register(eventBus);
    }

    public static RegistryObject<Enchantment> getEnchantment(String name) {
        return ENCHANTMENT_MAP.get(name);
    }

    static {
        ENCHANTMENT_MAP.put("void_assault", VOID_ASSAULT);
        ENCHANTMENT_MAP.put("chase", CHASE);
        ENCHANTMENT_MAP.put("soul_siphon", SOUL_SIPHON);
        ENCHANTMENT_MAP.put("ambush", AMBUSH);
        ENCHANTMENT_MAP.put("soul_conduit", SOUL_CONDUIT);
        ENCHANTMENT_MAP.put("poison", POISON);
        ENCHANTMENT_MAP.put("vigor", VIGOR);
        ENCHANTMENT_MAP.put("soul_resonance", SOUL_RESONANCE);
        ENCHANTMENT_MAP.put("explosion", EXPLOSION);
        ENCHANTMENT_MAP.put("pain_cycle", PAIN_CYCLE);
        ENCHANTMENT_MAP.put("prospector", PROSPECTOR);
        ENCHANTMENT_MAP.put("friendly", FRIENDLY);
        ENCHANTMENT_MAP.put("soul_synergy", SOUL_SYNERGY);
        ENCHANTMENT_MAP.put("frostbite", FROSTBITE);
        ENCHANTMENT_MAP.put("stun", STUN);
        ENCHANTMENT_MAP.put("illager_bane", ILLAGER_BANE);
        ENCHANTMENT_MAP.put("void_echo", VOID_ECHO);
        ENCHANTMENT_MAP.put("execute", EXECUTE);
        ENCHANTMENT_MAP.put("guardian_strike", GUARDIAN_STRIKE);
        ENCHANTMENT_MAP.put("busy_bee", BUSY_BEE);
        ENCHANTMENT_MAP.put("bonus_shot", BONUS_SHOT);
        ENCHANTMENT_MAP.put("charge", CHARGE);
    }
}

