/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.effect;

import com.bmt.de.effect.FrostbiteEffect;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dream_enchantment")
class FrostbiteEventHandler {
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("1a2b3c4d-5e6f-7a8b-9c0d-1e2f3a4b5c6d");
    private static final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.fromString("2b3c4d5e-6f7a-8b9c-0d1e-2f3a4b5c6d7e");

    FrostbiteEventHandler() {
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof FrostbiteEffect) {
            LivingEntity entity = event.getEntity();
            int amplifier = event.getEffectInstance().m_19564_();
            FrostbiteEventHandler.applySpeedReduction(entity, amplifier);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof FrostbiteEffect) {
            FrostbiteEventHandler.removeSpeedReduction(event.getEntity());
        }
    }

    private static void applySpeedReduction(LivingEntity entity, int amplifier) {
        double movementReduction = FrostbiteEventHandler.getMovementReduction(amplifier + 1);
        double attackSpeedReduction = FrostbiteEventHandler.getAttackSpeedReduction(amplifier + 1);
        if (entity.m_21051_(Attributes.f_22279_) != null) {
            entity.m_21051_(Attributes.f_22279_).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
            entity.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Frostbite Movement Slow", -movementReduction, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (entity.m_21051_(Attributes.f_22283_) != null) {
            entity.m_21051_(Attributes.f_22283_).m_22120_(ATTACK_SPEED_MODIFIER_UUID);
            entity.m_21051_(Attributes.f_22283_).m_22118_(new AttributeModifier(ATTACK_SPEED_MODIFIER_UUID, "Frostbite Attack Slow", -attackSpeedReduction, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void removeSpeedReduction(LivingEntity entity) {
        if (entity.m_21051_(Attributes.f_22279_) != null) {
            entity.m_21051_(Attributes.f_22279_).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
        }
        if (entity.m_21051_(Attributes.f_22283_) != null) {
            entity.m_21051_(Attributes.f_22283_).m_22120_(ATTACK_SPEED_MODIFIER_UUID);
        }
    }

    private static double getMovementReduction(int level) {
        return switch (level) {
            case 1 -> 0.15;
            case 2 -> 0.3;
            case 3 -> 0.45;
            case 4 -> 0.6;
            default -> 0.0;
        };
    }

    private static double getAttackSpeedReduction(int level) {
        return switch (level) {
            case 1 -> 0.1;
            case 2 -> 0.2;
            case 3 -> 0.3;
            case 4 -> 0.4;
            default -> 0.0;
        };
    }
}

