/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BonusShotEnchantment
extends BaseEnchantment {
    public BonusShotEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.BOW, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment other) {
        return super.m_5975_(other) && other != Enchantments.f_44959_;
    }

    public static void onArrowLaunch(AbstractArrow arrow, LivingEntity shooter, int level) {
        if (!shooter.m_9236_().f_46443_) {
            Optional<LivingEntity> nearestTarget;
            AABB searchArea = new AABB(shooter.m_20185_() - 20.0, shooter.m_20186_() - 20.0, shooter.m_20189_() - 20.0, shooter.m_20185_() + 20.0, shooter.m_20186_() + 20.0, shooter.m_20189_() + 20.0);
            List nearbyEntities = shooter.m_9236_().m_6443_(LivingEntity.class, searchArea, entity -> entity != shooter && entity.m_6084_() && !entity.m_7307_((Entity)shooter));
            if (!nearbyEntities.isEmpty() && (nearestTarget = nearbyEntities.stream().min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)shooter)))).isPresent()) {
                LivingEntity target = nearestTarget.get();
                BonusShotEnchantment.createBonusArrow(arrow, shooter, target, level);
            }
        }
    }

    private static void createBonusArrow(AbstractArrow originalArrow, LivingEntity shooter, LivingEntity target, int level) {
        Arrow bonusArrow = new Arrow(shooter.m_9236_(), shooter);
        bonusArrow.m_6034_(originalArrow.m_20185_(), originalArrow.m_20186_(), originalArrow.m_20189_());
        bonusArrow.getPersistentData().m_128379_("IsBonusShot", true);
        bonusArrow.m_5602_((Entity)shooter);
        float damageMultiplier = BonusShotEnchantment.getDamageMultiplier(level);
        double originalDamage = originalArrow.m_36789_();
        double bonusDamage = originalDamage * (double)damageMultiplier;
        bonusArrow.m_36781_(bonusDamage);
        bonusArrow.m_36762_(originalArrow.m_36792_());
        bonusArrow.m_36767_(originalArrow.m_36796_());
        bonusArrow.m_36735_(originalArrow.m_150123_());
        Vec3 targetPos = target.m_146892_();
        Vec3 arrowPos = bonusArrow.m_20182_();
        Vec3 direction = targetPos.m_82546_(arrowPos).m_82541_();
        float speed = 1.2f;
        float inaccuracy = 2.0f;
        bonusArrow.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, speed, inaccuracy);
        shooter.m_9236_().m_7967_((Entity)bonusArrow);
        shooter.m_9236_().m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11687_, shooter.m_5720_(), 0.3f, 1.5f);
        System.out.println("\u5956\u52b1\u5c04\u51fb\u89e6\u53d1: \u7b49\u7ea7 " + level + ", \u4f24\u5bb3 " + bonusDamage);
    }

    private static float getDamageMultiplier(int level) {
        return switch (level) {
            case 1 -> 0.1f;
            case 2 -> 0.17f;
            case 3 -> 0.24f;
            default -> 0.0f;
        };
    }
}

