/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;

public class BusyBeeEnchantment
extends BaseEnchantment {
    private static final Map<UUID, List<UUID>> playerBeesMap = new HashMap<UUID, List<UUID>>();
    private static final int MAX_BEES = 3;

    public BusyBeeEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 3;
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        if (!attacker.m_9236_().f_46443_ && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            float summonChance = this.getSummonChance(level);
            if (attacker.m_217043_().m_188501_() < summonChance && this.canSummonMoreBees(attacker)) {
                this.summonBee(attacker, livingTarget, level);
            }
        }
    }

    private float getSummonChance(int level) {
        return switch (level) {
            case 1 -> 0.2f;
            case 2 -> 0.3f;
            case 3 -> 0.4f;
            default -> 0.0f;
        };
    }

    private boolean canSummonMoreBees(LivingEntity attacker) {
        UUID attackerId = attacker.m_20148_();
        List bees = playerBeesMap.getOrDefault(attackerId, new ArrayList());
        this.cleanupDeadBees(attacker, bees);
        return bees.size() < 3;
    }

    private void summonBee(LivingEntity attacker, LivingEntity target, int level) {
        Level level2 = attacker.m_9236_();
        if (!(level2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level2;
        double spawnX = attacker.m_20185_() + (attacker.m_217043_().m_188500_() - 0.5) * 3.0;
        double spawnY = attacker.m_20186_() + 1.0;
        double spawnZ = attacker.m_20189_() + (attacker.m_217043_().m_188500_() - 0.5) * 3.0;
        Bee bee = new Bee(EntityType.f_20550_, (Level)serverLevel);
        bee.m_6034_(spawnX, spawnY, spawnZ);
        this.setupBee(bee, attacker, target, level);
        serverLevel.m_7967_((Entity)bee);
        this.recordBee(attacker, bee);
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11691_, attacker.m_5720_(), 0.5f, 1.0f);
        this.spawnSummonParticles(attacker, bee);
    }

    private void setupBee(Bee bee, LivingEntity owner, LivingEntity target, int level) {
        bee.m_7870_(0);
        bee.m_6925_(null);
        float baseHealth = 10.0f;
        float bonusHealth = (float)(level - 1) * 5.0f;
        bee.m_21153_(baseHealth + bonusHealth);
        bee.m_21051_(Attributes.f_22276_).m_22100_((double)(baseHealth + bonusHealth));
        float baseDamage = 2.0f;
        float bonusDamage = (float)(level - 1) * 1.0f;
        bee.m_21051_(Attributes.f_22281_).m_22100_((double)(baseDamage + bonusDamage));
        bee.m_6710_(target);
        bee.getPersistentData().m_128362_("OwnerUUID", owner.m_20148_());
        bee.m_21530_();
    }

    private void recordBee(LivingEntity owner, Bee bee) {
        UUID ownerId = owner.m_20148_();
        UUID beeId = bee.m_20148_();
        List bees = playerBeesMap.computeIfAbsent(ownerId, k -> new ArrayList());
        bees.add(beeId);
    }

    private void cleanupDeadBees(LivingEntity owner, List<UUID> bees) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        bees.removeIf(beeId -> {
            Entity entity = serverLevel.m_8791_(beeId);
            return entity == null || !entity.m_6084_() || !(entity instanceof Bee);
        });
    }

    private void spawnSummonParticles(LivingEntity owner, Bee bee) {
        if (owner.m_9236_().f_46443_) {
            for (int i = 0; i < 8; ++i) {
                double x = bee.m_20185_() + (owner.m_217043_().m_188500_() - 0.5) * (double)bee.m_20205_();
                double y = bee.m_20186_() + owner.m_217043_().m_188500_() * (double)bee.m_20206_();
                double z = bee.m_20189_() + (owner.m_217043_().m_188500_() - 0.5) * (double)bee.m_20205_();
                owner.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 0.0, 0.1, 0.0);
            }
        }
    }

    public static void cleanupAllDeadBees(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (List<UUID> bees : playerBeesMap.values()) {
            bees.removeIf(beeId -> {
                Entity entity = serverLevel.m_8791_(beeId);
                return entity == null || !entity.m_6084_() || !(entity instanceof Bee);
            });
        }
        playerBeesMap.entrySet().removeIf(entry -> ((List)entry.getValue()).isEmpty());
    }

    public static int getBeeCount(LivingEntity owner) {
        List<UUID> bees = playerBeesMap.get(owner.m_20148_());
        return bees != null ? bees.size() : 0;
    }

    public static void removeAllBees(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List<UUID> bees = playerBeesMap.remove(owner.m_20148_());
        if (bees != null) {
            for (UUID beeId : bees) {
                Entity entity = serverLevel.m_8791_(beeId);
                if (!(entity instanceof Bee)) continue;
                Bee bee = (Bee)entity;
                bee.m_146870_();
            }
        }
    }
}

