/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChargeEnchantment
extends BaseEnchantment {
    private static final Map<UUID, Long> chargeCooldownMap = new HashMap<UUID, Long>();
    private static final int COOLDOWN_TICKS = 20;

    public ChargeEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 1;
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        if (!attacker.m_9236_().f_46443_ && target instanceof LivingEntity) {
            if (this.isOnCooldown(attacker)) {
                return;
            }
            Vec3 lookVec = attacker.m_20154_();
            this.performCharge(attacker, lookVec, level);
            this.setCooldown(attacker);
        }
    }

    private void performCharge(LivingEntity attacker, Vec3 direction, int level) {
        double chargeStrength = 1.5;
        Vec3 velocity = direction.m_82490_(chargeStrength);
        attacker.m_20334_(velocity.f_82479_, velocity.f_82480_ + 0.1, velocity.f_82481_);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.f_19864_ = true;
        }
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12314_, attacker.m_5720_(), 1.0f, 0.8f);
        this.spawnChargeParticles(attacker);
        attacker.f_19864_ = true;
        System.out.println("\u51b2\u950b\u89e6\u53d1: " + attacker.m_7755_().getString() + " \u65b9\u5411: " + String.valueOf(direction));
    }

    private boolean isOnCooldown(LivingEntity entity) {
        UUID entityId = entity.m_20148_();
        Long lastChargeTime = chargeCooldownMap.get(entityId);
        if (lastChargeTime != null) {
            long currentTime = entity.m_9236_().m_46467_();
            return currentTime - lastChargeTime < 20L;
        }
        return false;
    }

    private void setCooldown(LivingEntity entity) {
        chargeCooldownMap.put(entity.m_20148_(), entity.m_9236_().m_46467_());
    }

    private void spawnChargeParticles(LivingEntity attacker) {
        if (attacker.m_9236_().f_46443_) {
            int i;
            for (i = 0; i < 15; ++i) {
                double offsetX = (attacker.m_217043_().m_188500_() - 0.5) * (double)attacker.m_20205_() * 2.0;
                double offsetY = attacker.m_217043_().m_188500_() * (double)attacker.m_20206_();
                double offsetZ = (attacker.m_217043_().m_188500_() - 0.5) * (double)attacker.m_20205_() * 2.0;
                attacker.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123766_, attacker.m_20185_() + offsetX, attacker.m_20186_() + offsetY, attacker.m_20189_() + offsetZ, 0.0, 0.1, 0.0);
            }
            for (i = 0; i < 8; ++i) {
                Vec3 lookVec = attacker.m_20154_();
                double forwardOffset = (double)i * 0.5;
                double sideOffset = (attacker.m_217043_().m_188500_() - 0.5) * 0.3;
                double particleX = attacker.m_20185_() + lookVec.f_82479_ * forwardOffset + lookVec.f_82481_ * sideOffset;
                double particleY = attacker.m_20186_() + 0.5;
                double particleZ = attacker.m_20189_() + lookVec.f_82481_ * forwardOffset - lookVec.f_82479_ * sideOffset;
                attacker.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, particleX, particleY, particleZ, 0.0, 0.05, 0.0);
            }
        }
    }

    public static void cleanupExpiredCooldowns(Level level) {
        long currentTime = level.m_46467_();
        chargeCooldownMap.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 40L);
    }
}

